package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VenafiCloudBuilder extends VenafiCloudFluent<VenafiCloudBuilder> implements VisitableBuilder<VenafiCloud,VenafiCloudBuilder>{
  public VenafiCloudBuilder() {
    this(false);
  }
  public VenafiCloudBuilder(Boolean validationEnabled) {
    this(new VenafiCloud(), validationEnabled);
  }
  public VenafiCloudBuilder(VenafiCloudFluent<?> fluent) {
    this(fluent, false);
  }
  public VenafiCloudBuilder(VenafiCloudFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VenafiCloud(), validationEnabled);
  }
  public VenafiCloudBuilder(VenafiCloudFluent<?> fluent,VenafiCloud instance) {
    this(fluent, instance, false);
  }
  public VenafiCloudBuilder(VenafiCloudFluent<?> fluent,VenafiCloud instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new VenafiCloud());

    if (instance != null) {
      fluent.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      fluent.withUrl(instance.getUrl());
      fluent.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public VenafiCloudBuilder(VenafiCloud instance) {
    this(instance,false);
  }
  public VenafiCloudBuilder(VenafiCloud instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new VenafiCloud());

    if (instance != null) {
      this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      this.withUrl(instance.getUrl());
      this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  VenafiCloudFluent<?> fluent;
  Boolean validationEnabled;
  public VenafiCloud build() {
    VenafiCloud buildable = new VenafiCloud(fluent.buildApiTokenSecretRef(),fluent.getUrl());
    return buildable;
  }
  
}