package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VaultKubernetesAuthFluent<A extends VaultKubernetesAuthFluent<A>> extends BaseFluent<A>{
  public VaultKubernetesAuthFluent() {
  }
  public VaultKubernetesAuthFluent(VaultKubernetesAuth instance) {
    instance = (instance != null ? instance : new VaultKubernetesAuth());

    if (instance != null) {
      this.withMountPath(instance.getMountPath());
      this.withRole(instance.getRole());
      this.withSecretRef(instance.getSecretRef());
      this.withMountPath(instance.getMountPath());
      this.withRole(instance.getRole());
      this.withSecretRef(instance.getSecretRef());
    }
  }
  private String mountPath;
  private String role;
  private SecretKeySelectorBuilder secretRef;
  public String getMountPath() {
    return this.mountPath;
  }
  public A withMountPath(String mountPath) {
    this.mountPath=mountPath; return (A) this;
  }
  public boolean hasMountPath() {
    return this.mountPath != null;
  }
  public String getRole() {
    return this.role;
  }
  public A withRole(String role) {
    this.role=role; return (A) this;
  }
  public boolean hasRole() {
    return this.role != null;
  }
  public SecretKeySelector buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(SecretKeySelector secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new SecretKeySelectorBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(String key,String name) {
    return (A)withSecretRef(new SecretKeySelector(key, name));
  }
  public SecretRefNested<A> withNewSecretRef() {
    return new SecretRefNested(null);
  }
  public SecretRefNested<A> withNewSecretRefLike(SecretKeySelector item) {
    return new SecretRefNested(item);
  }
  public SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(null));
  }
  public SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  public SecretRefNested<A> editOrNewSecretRefLike(SecretKeySelector item) {
    return withNewSecretRefLike(java.util.Optional.ofNullable(buildSecretRef()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VaultKubernetesAuthFluent that = (VaultKubernetesAuthFluent) o;
    if (!java.util.Objects.equals(mountPath, that.mountPath)) return false;

    if (!java.util.Objects.equals(role, that.role)) return false;

    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(mountPath,  role,  secretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretRefNested<N> extends SecretKeySelectorFluent<SecretRefNested<N>> implements Nested<N>{
    SecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) VaultKubernetesAuthFluent.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}