package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IssuerStatusBuilder extends IssuerStatusFluent<IssuerStatusBuilder> implements VisitableBuilder<IssuerStatus,IssuerStatusBuilder>{
  public IssuerStatusBuilder() {
    this(false);
  }
  public IssuerStatusBuilder(Boolean validationEnabled) {
    this(new IssuerStatus(), validationEnabled);
  }
  public IssuerStatusBuilder(IssuerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IssuerStatusBuilder(IssuerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IssuerStatus(), validationEnabled);
  }
  public IssuerStatusBuilder(IssuerStatusFluent<?> fluent,IssuerStatus instance) {
    this(fluent, instance, false);
  }
  public IssuerStatusBuilder(IssuerStatusFluent<?> fluent,IssuerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IssuerStatus());

    if (instance != null) {
      fluent.withAcme(instance.getAcme());
      fluent.withConditions(instance.getConditions());
      fluent.withAcme(instance.getAcme());
      fluent.withConditions(instance.getConditions());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IssuerStatusBuilder(IssuerStatus instance) {
    this(instance,false);
  }
  public IssuerStatusBuilder(IssuerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IssuerStatus());

    if (instance != null) {
      this.withAcme(instance.getAcme());
      this.withConditions(instance.getConditions());
      this.withAcme(instance.getAcme());
      this.withConditions(instance.getConditions());
    }
    this.validationEnabled = validationEnabled; 
  }
  IssuerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IssuerStatus build() {
    IssuerStatus buildable = new IssuerStatus(fluent.buildAcme(),fluent.buildConditions());
    return buildable;
  }
  
}