package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterIssuerBuilder extends ClusterIssuerFluent<ClusterIssuerBuilder> implements VisitableBuilder<ClusterIssuer,ClusterIssuerBuilder>{
  public ClusterIssuerBuilder() {
    this(false);
  }
  public ClusterIssuerBuilder(Boolean validationEnabled) {
    this(new ClusterIssuer(), validationEnabled);
  }
  public ClusterIssuerBuilder(ClusterIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterIssuerBuilder(ClusterIssuerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterIssuer(), validationEnabled);
  }
  public ClusterIssuerBuilder(ClusterIssuerFluent<?> fluent,ClusterIssuer instance) {
    this(fluent, instance, false);
  }
  public ClusterIssuerBuilder(ClusterIssuerFluent<?> fluent,ClusterIssuer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClusterIssuer());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClusterIssuerBuilder(ClusterIssuer instance) {
    this(instance,false);
  }
  public ClusterIssuerBuilder(ClusterIssuer instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClusterIssuer());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClusterIssuerFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterIssuer build() {
    ClusterIssuer buildable = new ClusterIssuer(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}