package io.fabric8.certmanager.api.model.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateSpecFluent<A extends CertificateSpecFluent<A>> extends BaseFluent<A>{
  public CertificateSpecFluent() {
  }
  public CertificateSpecFluent(CertificateSpec instance) {
    instance = (instance != null ? instance : new CertificateSpec());

    if (instance != null) {
      this.withCommonName(instance.getCommonName());
      this.withDnsNames(instance.getDnsNames());
      this.withDuration(instance.getDuration());
      this.withEmailSANs(instance.getEmailSANs());
      this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
      this.withIpAddresses(instance.getIpAddresses());
      this.withIsCA(instance.getIsCA());
      this.withIssuerRef(instance.getIssuerRef());
      this.withKeyAlgorithm(instance.getKeyAlgorithm());
      this.withKeyEncoding(instance.getKeyEncoding());
      this.withKeySize(instance.getKeySize());
      this.withKeystores(instance.getKeystores());
      this.withPrivateKey(instance.getPrivateKey());
      this.withRenewBefore(instance.getRenewBefore());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSecretName(instance.getSecretName());
      this.withSecretTemplate(instance.getSecretTemplate());
      this.withSubject(instance.getSubject());
      this.withUriSANs(instance.getUriSANs());
      this.withUsages(instance.getUsages());
      this.withCommonName(instance.getCommonName());
      this.withDnsNames(instance.getDnsNames());
      this.withDuration(instance.getDuration());
      this.withEmailSANs(instance.getEmailSANs());
      this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
      this.withIpAddresses(instance.getIpAddresses());
      this.withIsCA(instance.getIsCA());
      this.withIssuerRef(instance.getIssuerRef());
      this.withKeyAlgorithm(instance.getKeyAlgorithm());
      this.withKeyEncoding(instance.getKeyEncoding());
      this.withKeySize(instance.getKeySize());
      this.withKeystores(instance.getKeystores());
      this.withPrivateKey(instance.getPrivateKey());
      this.withRenewBefore(instance.getRenewBefore());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSecretName(instance.getSecretName());
      this.withSecretTemplate(instance.getSecretTemplate());
      this.withSubject(instance.getSubject());
      this.withUriSANs(instance.getUriSANs());
      this.withUsages(instance.getUsages());
    }
  }
  private String commonName;
  private List<String> dnsNames = new ArrayList<String>();
  private Duration duration;
  private List<String> emailSANs = new ArrayList<String>();
  private Boolean encodeUsagesInRequest;
  private List<String> ipAddresses = new ArrayList<String>();
  private Boolean isCA;
  private ObjectReferenceBuilder issuerRef;
  private String keyAlgorithm;
  private String keyEncoding;
  private Integer keySize;
  private CertificateKeystoresBuilder keystores;
  private CertificatePrivateKeyBuilder privateKey;
  private Duration renewBefore;
  private Integer revisionHistoryLimit;
  private String secretName;
  private CertificateSecretTemplateBuilder secretTemplate;
  private X509SubjectBuilder subject;
  private List<String> uriSANs = new ArrayList<String>();
  private List<String> usages = new ArrayList<String>();
  public String getCommonName() {
    return this.commonName;
  }
  public A withCommonName(String commonName) {
    this.commonName=commonName; return (A) this;
  }
  public boolean hasCommonName() {
    return this.commonName != null;
  }
  public A addToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(int index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    if (this.dnsNames == null) return (A)this;
    for (String item : items) { this.dnsNames.remove(item);} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(int index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear(); _visitables.remove("dnsNames"); }
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public boolean hasDuration() {
    return this.duration != null;
  }
  public A addToEmailSANs(int index,String item) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    this.emailSANs.add(index, item);
    return (A)this;
  }
  public A setToEmailSANs(int index,String item) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    this.emailSANs.set(index, item); return (A)this;
  }
  public A addToEmailSANs(java.lang.String... items) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    for (String item : items) {this.emailSANs.add(item);} return (A)this;
  }
  public A addAllToEmailSANs(Collection<String> items) {
    if (this.emailSANs == null) {this.emailSANs = new ArrayList<String>();}
    for (String item : items) {this.emailSANs.add(item);} return (A)this;
  }
  public A removeFromEmailSANs(java.lang.String... items) {
    if (this.emailSANs == null) return (A)this;
    for (String item : items) { this.emailSANs.remove(item);} return (A)this;
  }
  public A removeAllFromEmailSANs(Collection<String> items) {
    if (this.emailSANs == null) return (A)this;
    for (String item : items) { this.emailSANs.remove(item);} return (A)this;
  }
  public List<String> getEmailSANs() {
    return this.emailSANs;
  }
  public String getEmailSAN(int index) {
    return this.emailSANs.get(index);
  }
  public String getFirstEmailSAN() {
    return this.emailSANs.get(0);
  }
  public String getLastEmailSAN() {
    return this.emailSANs.get(emailSANs.size() - 1);
  }
  public String getMatchingEmailSAN(Predicate<String> predicate) {
    for (String item: emailSANs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingEmailSAN(Predicate<String> predicate) {
    for (String item: emailSANs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEmailSANs(List<String> emailSANs) {
    if (emailSANs != null) {this.emailSANs = new ArrayList(); for (String item : emailSANs){this.addToEmailSANs(item);}} else { this.emailSANs = null;} return (A) this;
  }
  public A withEmailSANs(java.lang.String... emailSANs) {
    if (this.emailSANs != null) {this.emailSANs.clear(); _visitables.remove("emailSANs"); }
    if (emailSANs != null) {for (String item :emailSANs){ this.addToEmailSANs(item);}} return (A) this;
  }
  public boolean hasEmailSANs() {
    return emailSANs != null && !emailSANs.isEmpty();
  }
  public Boolean getEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest;
  }
  public A withEncodeUsagesInRequest(Boolean encodeUsagesInRequest) {
    this.encodeUsagesInRequest=encodeUsagesInRequest; return (A) this;
  }
  public boolean hasEncodeUsagesInRequest() {
    return this.encodeUsagesInRequest != null;
  }
  public A addToIpAddresses(int index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.add(index, item);
    return (A)this;
  }
  public A setToIpAddresses(int index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.set(index, item); return (A)this;
  }
  public A addToIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A addAllToIpAddresses(Collection<String> items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A removeFromIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) return (A)this;
    for (String item : items) { this.ipAddresses.remove(item);} return (A)this;
  }
  public A removeAllFromIpAddresses(Collection<String> items) {
    if (this.ipAddresses == null) return (A)this;
    for (String item : items) { this.ipAddresses.remove(item);} return (A)this;
  }
  public List<String> getIpAddresses() {
    return this.ipAddresses;
  }
  public String getIpAddress(int index) {
    return this.ipAddresses.get(index);
  }
  public String getFirstIpAddress() {
    return this.ipAddresses.get(0);
  }
  public String getLastIpAddress() {
    return this.ipAddresses.get(ipAddresses.size() - 1);
  }
  public String getMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpAddresses(List<String> ipAddresses) {
    if (ipAddresses != null) {this.ipAddresses = new ArrayList(); for (String item : ipAddresses){this.addToIpAddresses(item);}} else { this.ipAddresses = null;} return (A) this;
  }
  public A withIpAddresses(java.lang.String... ipAddresses) {
    if (this.ipAddresses != null) {this.ipAddresses.clear(); _visitables.remove("ipAddresses"); }
    if (ipAddresses != null) {for (String item :ipAddresses){ this.addToIpAddresses(item);}} return (A) this;
  }
  public boolean hasIpAddresses() {
    return ipAddresses != null && !ipAddresses.isEmpty();
  }
  public Boolean getIsCA() {
    return this.isCA;
  }
  public A withIsCA(Boolean isCA) {
    this.isCA=isCA; return (A) this;
  }
  public boolean hasIsCA() {
    return this.isCA != null;
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public IssuerRefNested<A> withNewIssuerRef() {
    return new IssuerRefNested(null);
  }
  public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new IssuerRefNested(item);
  }
  public IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(null));
  }
  public IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(java.util.Optional.ofNullable(buildIssuerRef()).orElse(item));
  }
  public String getKeyAlgorithm() {
    return this.keyAlgorithm;
  }
  public A withKeyAlgorithm(String keyAlgorithm) {
    this.keyAlgorithm=keyAlgorithm; return (A) this;
  }
  public boolean hasKeyAlgorithm() {
    return this.keyAlgorithm != null;
  }
  public String getKeyEncoding() {
    return this.keyEncoding;
  }
  public A withKeyEncoding(String keyEncoding) {
    this.keyEncoding=keyEncoding; return (A) this;
  }
  public boolean hasKeyEncoding() {
    return this.keyEncoding != null;
  }
  public Integer getKeySize() {
    return this.keySize;
  }
  public A withKeySize(Integer keySize) {
    this.keySize=keySize; return (A) this;
  }
  public boolean hasKeySize() {
    return this.keySize != null;
  }
  public CertificateKeystores buildKeystores() {
    return this.keystores!=null ?this.keystores.build():null;
  }
  public A withKeystores(CertificateKeystores keystores) {
    _visitables.get("keystores").remove(this.keystores);
    if (keystores!=null){ this.keystores= new CertificateKeystoresBuilder(keystores); _visitables.get("keystores").add(this.keystores);} else { this.keystores = null; _visitables.get("keystores").remove(this.keystores); } return (A) this;
  }
  public boolean hasKeystores() {
    return this.keystores != null;
  }
  public KeystoresNested<A> withNewKeystores() {
    return new KeystoresNested(null);
  }
  public KeystoresNested<A> withNewKeystoresLike(CertificateKeystores item) {
    return new KeystoresNested(item);
  }
  public KeystoresNested<A> editKeystores() {
    return withNewKeystoresLike(java.util.Optional.ofNullable(buildKeystores()).orElse(null));
  }
  public KeystoresNested<A> editOrNewKeystores() {
    return withNewKeystoresLike(java.util.Optional.ofNullable(buildKeystores()).orElse(new CertificateKeystoresBuilder().build()));
  }
  public KeystoresNested<A> editOrNewKeystoresLike(CertificateKeystores item) {
    return withNewKeystoresLike(java.util.Optional.ofNullable(buildKeystores()).orElse(item));
  }
  public CertificatePrivateKey buildPrivateKey() {
    return this.privateKey!=null ?this.privateKey.build():null;
  }
  public A withPrivateKey(CertificatePrivateKey privateKey) {
    _visitables.get("privateKey").remove(this.privateKey);
    if (privateKey!=null){ this.privateKey= new CertificatePrivateKeyBuilder(privateKey); _visitables.get("privateKey").add(this.privateKey);} else { this.privateKey = null; _visitables.get("privateKey").remove(this.privateKey); } return (A) this;
  }
  public boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  public A withNewPrivateKey(String rotationPolicy) {
    return (A)withPrivateKey(new CertificatePrivateKey(rotationPolicy));
  }
  public PrivateKeyNested<A> withNewPrivateKey() {
    return new PrivateKeyNested(null);
  }
  public PrivateKeyNested<A> withNewPrivateKeyLike(CertificatePrivateKey item) {
    return new PrivateKeyNested(item);
  }
  public PrivateKeyNested<A> editPrivateKey() {
    return withNewPrivateKeyLike(java.util.Optional.ofNullable(buildPrivateKey()).orElse(null));
  }
  public PrivateKeyNested<A> editOrNewPrivateKey() {
    return withNewPrivateKeyLike(java.util.Optional.ofNullable(buildPrivateKey()).orElse(new CertificatePrivateKeyBuilder().build()));
  }
  public PrivateKeyNested<A> editOrNewPrivateKeyLike(CertificatePrivateKey item) {
    return withNewPrivateKeyLike(java.util.Optional.ofNullable(buildPrivateKey()).orElse(item));
  }
  public Duration getRenewBefore() {
    return this.renewBefore;
  }
  public A withRenewBefore(Duration renewBefore) {
    this.renewBefore=renewBefore; return (A) this;
  }
  public boolean hasRenewBefore() {
    return this.renewBefore != null;
  }
  public Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  public boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  public String getSecretName() {
    return this.secretName;
  }
  public A withSecretName(String secretName) {
    this.secretName=secretName; return (A) this;
  }
  public boolean hasSecretName() {
    return this.secretName != null;
  }
  public CertificateSecretTemplate buildSecretTemplate() {
    return this.secretTemplate!=null ?this.secretTemplate.build():null;
  }
  public A withSecretTemplate(CertificateSecretTemplate secretTemplate) {
    _visitables.get("secretTemplate").remove(this.secretTemplate);
    if (secretTemplate!=null){ this.secretTemplate= new CertificateSecretTemplateBuilder(secretTemplate); _visitables.get("secretTemplate").add(this.secretTemplate);} else { this.secretTemplate = null; _visitables.get("secretTemplate").remove(this.secretTemplate); } return (A) this;
  }
  public boolean hasSecretTemplate() {
    return this.secretTemplate != null;
  }
  public SecretTemplateNested<A> withNewSecretTemplate() {
    return new SecretTemplateNested(null);
  }
  public SecretTemplateNested<A> withNewSecretTemplateLike(CertificateSecretTemplate item) {
    return new SecretTemplateNested(item);
  }
  public SecretTemplateNested<A> editSecretTemplate() {
    return withNewSecretTemplateLike(java.util.Optional.ofNullable(buildSecretTemplate()).orElse(null));
  }
  public SecretTemplateNested<A> editOrNewSecretTemplate() {
    return withNewSecretTemplateLike(java.util.Optional.ofNullable(buildSecretTemplate()).orElse(new CertificateSecretTemplateBuilder().build()));
  }
  public SecretTemplateNested<A> editOrNewSecretTemplateLike(CertificateSecretTemplate item) {
    return withNewSecretTemplateLike(java.util.Optional.ofNullable(buildSecretTemplate()).orElse(item));
  }
  public X509Subject buildSubject() {
    return this.subject!=null ?this.subject.build():null;
  }
  public A withSubject(X509Subject subject) {
    _visitables.get("subject").remove(this.subject);
    if (subject!=null){ this.subject= new X509SubjectBuilder(subject); _visitables.get("subject").add(this.subject);} else { this.subject = null; _visitables.get("subject").remove(this.subject); } return (A) this;
  }
  public boolean hasSubject() {
    return this.subject != null;
  }
  public SubjectNested<A> withNewSubject() {
    return new SubjectNested(null);
  }
  public SubjectNested<A> withNewSubjectLike(X509Subject item) {
    return new SubjectNested(item);
  }
  public SubjectNested<A> editSubject() {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(null));
  }
  public SubjectNested<A> editOrNewSubject() {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(new X509SubjectBuilder().build()));
  }
  public SubjectNested<A> editOrNewSubjectLike(X509Subject item) {
    return withNewSubjectLike(java.util.Optional.ofNullable(buildSubject()).orElse(item));
  }
  public A addToUriSANs(int index,String item) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    this.uriSANs.add(index, item);
    return (A)this;
  }
  public A setToUriSANs(int index,String item) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    this.uriSANs.set(index, item); return (A)this;
  }
  public A addToUriSANs(java.lang.String... items) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    for (String item : items) {this.uriSANs.add(item);} return (A)this;
  }
  public A addAllToUriSANs(Collection<String> items) {
    if (this.uriSANs == null) {this.uriSANs = new ArrayList<String>();}
    for (String item : items) {this.uriSANs.add(item);} return (A)this;
  }
  public A removeFromUriSANs(java.lang.String... items) {
    if (this.uriSANs == null) return (A)this;
    for (String item : items) { this.uriSANs.remove(item);} return (A)this;
  }
  public A removeAllFromUriSANs(Collection<String> items) {
    if (this.uriSANs == null) return (A)this;
    for (String item : items) { this.uriSANs.remove(item);} return (A)this;
  }
  public List<String> getUriSANs() {
    return this.uriSANs;
  }
  public String getUriSAN(int index) {
    return this.uriSANs.get(index);
  }
  public String getFirstUriSAN() {
    return this.uriSANs.get(0);
  }
  public String getLastUriSAN() {
    return this.uriSANs.get(uriSANs.size() - 1);
  }
  public String getMatchingUriSAN(Predicate<String> predicate) {
    for (String item: uriSANs) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingUriSAN(Predicate<String> predicate) {
    for (String item: uriSANs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUriSANs(List<String> uriSANs) {
    if (uriSANs != null) {this.uriSANs = new ArrayList(); for (String item : uriSANs){this.addToUriSANs(item);}} else { this.uriSANs = null;} return (A) this;
  }
  public A withUriSANs(java.lang.String... uriSANs) {
    if (this.uriSANs != null) {this.uriSANs.clear(); _visitables.remove("uriSANs"); }
    if (uriSANs != null) {for (String item :uriSANs){ this.addToUriSANs(item);}} return (A) this;
  }
  public boolean hasUriSANs() {
    return uriSANs != null && !uriSANs.isEmpty();
  }
  public A addToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  public A setToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A removeFromUsages(java.lang.String... items) {
    if (this.usages == null) return (A)this;
    for (String item : items) { this.usages.remove(item);} return (A)this;
  }
  public A removeAllFromUsages(Collection<String> items) {
    if (this.usages == null) return (A)this;
    for (String item : items) { this.usages.remove(item);} return (A)this;
  }
  public List<String> getUsages() {
    return this.usages;
  }
  public String getUsage(int index) {
    return this.usages.get(index);
  }
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  public String getMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsages(List<String> usages) {
    if (usages != null) {this.usages = new ArrayList(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear(); _visitables.remove("usages"); }
    if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  public boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateSpecFluent that = (CertificateSpecFluent) o;
    if (!java.util.Objects.equals(commonName, that.commonName)) return false;

    if (!java.util.Objects.equals(dnsNames, that.dnsNames)) return false;

    if (!java.util.Objects.equals(duration, that.duration)) return false;

    if (!java.util.Objects.equals(emailSANs, that.emailSANs)) return false;

    if (!java.util.Objects.equals(encodeUsagesInRequest, that.encodeUsagesInRequest)) return false;

    if (!java.util.Objects.equals(ipAddresses, that.ipAddresses)) return false;

    if (!java.util.Objects.equals(isCA, that.isCA)) return false;

    if (!java.util.Objects.equals(issuerRef, that.issuerRef)) return false;

    if (!java.util.Objects.equals(keyAlgorithm, that.keyAlgorithm)) return false;

    if (!java.util.Objects.equals(keyEncoding, that.keyEncoding)) return false;

    if (!java.util.Objects.equals(keySize, that.keySize)) return false;

    if (!java.util.Objects.equals(keystores, that.keystores)) return false;

    if (!java.util.Objects.equals(privateKey, that.privateKey)) return false;

    if (!java.util.Objects.equals(renewBefore, that.renewBefore)) return false;

    if (!java.util.Objects.equals(revisionHistoryLimit, that.revisionHistoryLimit)) return false;

    if (!java.util.Objects.equals(secretName, that.secretName)) return false;

    if (!java.util.Objects.equals(secretTemplate, that.secretTemplate)) return false;

    if (!java.util.Objects.equals(subject, that.subject)) return false;

    if (!java.util.Objects.equals(uriSANs, that.uriSANs)) return false;

    if (!java.util.Objects.equals(usages, that.usages)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(commonName,  dnsNames,  duration,  emailSANs,  encodeUsagesInRequest,  ipAddresses,  isCA,  issuerRef,  keyAlgorithm,  keyEncoding,  keySize,  keystores,  privateKey,  renewBefore,  revisionHistoryLimit,  secretName,  secretTemplate,  subject,  uriSANs,  usages,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (emailSANs != null && !emailSANs.isEmpty()) { sb.append("emailSANs:"); sb.append(emailSANs + ","); }
    if (encodeUsagesInRequest != null) { sb.append("encodeUsagesInRequest:"); sb.append(encodeUsagesInRequest + ","); }
    if (ipAddresses != null && !ipAddresses.isEmpty()) { sb.append("ipAddresses:"); sb.append(ipAddresses + ","); }
    if (isCA != null) { sb.append("isCA:"); sb.append(isCA + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef + ","); }
    if (keyAlgorithm != null) { sb.append("keyAlgorithm:"); sb.append(keyAlgorithm + ","); }
    if (keyEncoding != null) { sb.append("keyEncoding:"); sb.append(keyEncoding + ","); }
    if (keySize != null) { sb.append("keySize:"); sb.append(keySize + ","); }
    if (keystores != null) { sb.append("keystores:"); sb.append(keystores + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (renewBefore != null) { sb.append("renewBefore:"); sb.append(renewBefore + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (secretName != null) { sb.append("secretName:"); sb.append(secretName + ","); }
    if (secretTemplate != null) { sb.append("secretTemplate:"); sb.append(secretTemplate + ","); }
    if (subject != null) { sb.append("subject:"); sb.append(subject + ","); }
    if (uriSANs != null && !uriSANs.isEmpty()) { sb.append("uriSANs:"); sb.append(uriSANs + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages); }
    sb.append("}");
    return sb.toString();
  }
  public A withEncodeUsagesInRequest() {
    return withEncodeUsagesInRequest(true);
  }
  public A withIsCA() {
    return withIsCA(true);
  }
  public class IssuerRefNested<N> extends ObjectReferenceFluent<IssuerRefNested<N>> implements Nested<N>{
    IssuerRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) CertificateSpecFluent.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  public class KeystoresNested<N> extends CertificateKeystoresFluent<KeystoresNested<N>> implements Nested<N>{
    KeystoresNested(CertificateKeystores item) {
      this.builder = new CertificateKeystoresBuilder(this, item);
    }
    CertificateKeystoresBuilder builder;
    public N and() {
      return (N) CertificateSpecFluent.this.withKeystores(builder.build());
    }
    public N endKeystores() {
      return and();
    }
    
  }
  public class PrivateKeyNested<N> extends CertificatePrivateKeyFluent<PrivateKeyNested<N>> implements Nested<N>{
    PrivateKeyNested(CertificatePrivateKey item) {
      this.builder = new CertificatePrivateKeyBuilder(this, item);
    }
    CertificatePrivateKeyBuilder builder;
    public N and() {
      return (N) CertificateSpecFluent.this.withPrivateKey(builder.build());
    }
    public N endPrivateKey() {
      return and();
    }
    
  }
  public class SecretTemplateNested<N> extends CertificateSecretTemplateFluent<SecretTemplateNested<N>> implements Nested<N>{
    SecretTemplateNested(CertificateSecretTemplate item) {
      this.builder = new CertificateSecretTemplateBuilder(this, item);
    }
    CertificateSecretTemplateBuilder builder;
    public N and() {
      return (N) CertificateSpecFluent.this.withSecretTemplate(builder.build());
    }
    public N endSecretTemplate() {
      return and();
    }
    
  }
  public class SubjectNested<N> extends X509SubjectFluent<SubjectNested<N>> implements Nested<N>{
    SubjectNested(X509Subject item) {
      this.builder = new X509SubjectBuilder(this, item);
    }
    X509SubjectBuilder builder;
    public N and() {
      return (N) CertificateSpecFluent.this.withSubject(builder.build());
    }
    public N endSubject() {
      return and();
    }
    
  }
  
}