package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSpecBuilder extends CertificateSpecFluent<CertificateSpecBuilder> implements VisitableBuilder<CertificateSpec,CertificateSpecBuilder>{
  public CertificateSpecBuilder() {
    this(false);
  }
  public CertificateSpecBuilder(Boolean validationEnabled) {
    this(new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,CertificateSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent,CertificateSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateSpec());

    if (instance != null) {
      fluent.withCommonName(instance.getCommonName());
      fluent.withDnsNames(instance.getDnsNames());
      fluent.withDuration(instance.getDuration());
      fluent.withEmailSANs(instance.getEmailSANs());
      fluent.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
      fluent.withIpAddresses(instance.getIpAddresses());
      fluent.withIsCA(instance.getIsCA());
      fluent.withIssuerRef(instance.getIssuerRef());
      fluent.withKeyAlgorithm(instance.getKeyAlgorithm());
      fluent.withKeyEncoding(instance.getKeyEncoding());
      fluent.withKeySize(instance.getKeySize());
      fluent.withKeystores(instance.getKeystores());
      fluent.withPrivateKey(instance.getPrivateKey());
      fluent.withRenewBefore(instance.getRenewBefore());
      fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      fluent.withSecretName(instance.getSecretName());
      fluent.withSecretTemplate(instance.getSecretTemplate());
      fluent.withSubject(instance.getSubject());
      fluent.withUriSANs(instance.getUriSANs());
      fluent.withUsages(instance.getUsages());
      fluent.withCommonName(instance.getCommonName());
      fluent.withDnsNames(instance.getDnsNames());
      fluent.withDuration(instance.getDuration());
      fluent.withEmailSANs(instance.getEmailSANs());
      fluent.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
      fluent.withIpAddresses(instance.getIpAddresses());
      fluent.withIsCA(instance.getIsCA());
      fluent.withIssuerRef(instance.getIssuerRef());
      fluent.withKeyAlgorithm(instance.getKeyAlgorithm());
      fluent.withKeyEncoding(instance.getKeyEncoding());
      fluent.withKeySize(instance.getKeySize());
      fluent.withKeystores(instance.getKeystores());
      fluent.withPrivateKey(instance.getPrivateKey());
      fluent.withRenewBefore(instance.getRenewBefore());
      fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      fluent.withSecretName(instance.getSecretName());
      fluent.withSecretTemplate(instance.getSecretTemplate());
      fluent.withSubject(instance.getSubject());
      fluent.withUriSANs(instance.getUriSANs());
      fluent.withUsages(instance.getUsages());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSpecBuilder(CertificateSpec instance) {
    this(instance,false);
  }
  public CertificateSpecBuilder(CertificateSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateSpec());

    if (instance != null) {
      this.withCommonName(instance.getCommonName());
      this.withDnsNames(instance.getDnsNames());
      this.withDuration(instance.getDuration());
      this.withEmailSANs(instance.getEmailSANs());
      this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
      this.withIpAddresses(instance.getIpAddresses());
      this.withIsCA(instance.getIsCA());
      this.withIssuerRef(instance.getIssuerRef());
      this.withKeyAlgorithm(instance.getKeyAlgorithm());
      this.withKeyEncoding(instance.getKeyEncoding());
      this.withKeySize(instance.getKeySize());
      this.withKeystores(instance.getKeystores());
      this.withPrivateKey(instance.getPrivateKey());
      this.withRenewBefore(instance.getRenewBefore());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSecretName(instance.getSecretName());
      this.withSecretTemplate(instance.getSecretTemplate());
      this.withSubject(instance.getSubject());
      this.withUriSANs(instance.getUriSANs());
      this.withUsages(instance.getUsages());
      this.withCommonName(instance.getCommonName());
      this.withDnsNames(instance.getDnsNames());
      this.withDuration(instance.getDuration());
      this.withEmailSANs(instance.getEmailSANs());
      this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest());
      this.withIpAddresses(instance.getIpAddresses());
      this.withIsCA(instance.getIsCA());
      this.withIssuerRef(instance.getIssuerRef());
      this.withKeyAlgorithm(instance.getKeyAlgorithm());
      this.withKeyEncoding(instance.getKeyEncoding());
      this.withKeySize(instance.getKeySize());
      this.withKeystores(instance.getKeystores());
      this.withPrivateKey(instance.getPrivateKey());
      this.withRenewBefore(instance.getRenewBefore());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSecretName(instance.getSecretName());
      this.withSecretTemplate(instance.getSecretTemplate());
      this.withSubject(instance.getSubject());
      this.withUriSANs(instance.getUriSANs());
      this.withUsages(instance.getUsages());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateSpecFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSpec build() {
    CertificateSpec buildable = new CertificateSpec(fluent.getCommonName(),fluent.getDnsNames(),fluent.getDuration(),fluent.getEmailSANs(),fluent.getEncodeUsagesInRequest(),fluent.getIpAddresses(),fluent.getIsCA(),fluent.buildIssuerRef(),fluent.getKeyAlgorithm(),fluent.getKeyEncoding(),fluent.getKeySize(),fluent.buildKeystores(),fluent.buildPrivateKey(),fluent.getRenewBefore(),fluent.getRevisionHistoryLimit(),fluent.getSecretName(),fluent.buildSecretTemplate(),fluent.buildSubject(),fluent.getUriSANs(),fluent.getUsages());
    return buildable;
  }
  
}