package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateRequestBuilder extends CertificateRequestFluent<CertificateRequestBuilder> implements VisitableBuilder<CertificateRequest,CertificateRequestBuilder>{
  public CertificateRequestBuilder() {
    this(false);
  }
  public CertificateRequestBuilder(Boolean validationEnabled) {
    this(new CertificateRequest(), validationEnabled);
  }
  public CertificateRequestBuilder(CertificateRequestFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateRequestBuilder(CertificateRequestFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateRequest(), validationEnabled);
  }
  public CertificateRequestBuilder(CertificateRequestFluent<?> fluent,CertificateRequest instance) {
    this(fluent, instance, false);
  }
  public CertificateRequestBuilder(CertificateRequestFluent<?> fluent,CertificateRequest instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateRequest());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateRequestBuilder(CertificateRequest instance) {
    this(instance,false);
  }
  public CertificateRequestBuilder(CertificateRequest instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateRequest());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateRequestFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateRequest build() {
    CertificateRequest buildable = new CertificateRequest(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}