package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateKeystoresBuilder extends CertificateKeystoresFluent<CertificateKeystoresBuilder> implements VisitableBuilder<CertificateKeystores,CertificateKeystoresBuilder>{
  public CertificateKeystoresBuilder() {
    this(false);
  }
  public CertificateKeystoresBuilder(Boolean validationEnabled) {
    this(new CertificateKeystores(), validationEnabled);
  }
  public CertificateKeystoresBuilder(CertificateKeystoresFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateKeystoresBuilder(CertificateKeystoresFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateKeystores(), validationEnabled);
  }
  public CertificateKeystoresBuilder(CertificateKeystoresFluent<?> fluent,CertificateKeystores instance) {
    this(fluent, instance, false);
  }
  public CertificateKeystoresBuilder(CertificateKeystoresFluent<?> fluent,CertificateKeystores instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateKeystores());

    if (instance != null) {
      fluent.withJks(instance.getJks());
      fluent.withPkcs12(instance.getPkcs12());
      fluent.withJks(instance.getJks());
      fluent.withPkcs12(instance.getPkcs12());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateKeystoresBuilder(CertificateKeystores instance) {
    this(instance,false);
  }
  public CertificateKeystoresBuilder(CertificateKeystores instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateKeystores());

    if (instance != null) {
      this.withJks(instance.getJks());
      this.withPkcs12(instance.getPkcs12());
      this.withJks(instance.getJks());
      this.withPkcs12(instance.getPkcs12());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateKeystoresFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateKeystores build() {
    CertificateKeystores buildable = new CertificateKeystores(fluent.buildJks(),fluent.buildPkcs12());
    return buildable;
  }
  
}