package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ChallengeBuilder extends ChallengeFluent<ChallengeBuilder> implements VisitableBuilder<Challenge,ChallengeBuilder>{
  public ChallengeBuilder() {
    this(false);
  }
  public ChallengeBuilder(Boolean validationEnabled) {
    this(new Challenge(), validationEnabled);
  }
  public ChallengeBuilder(ChallengeFluent<?> fluent) {
    this(fluent, false);
  }
  public ChallengeBuilder(ChallengeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Challenge(), validationEnabled);
  }
  public ChallengeBuilder(ChallengeFluent<?> fluent,Challenge instance) {
    this(fluent, instance, false);
  }
  public ChallengeBuilder(ChallengeFluent<?> fluent,Challenge instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Challenge());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ChallengeBuilder(Challenge instance) {
    this(instance,false);
  }
  public ChallengeBuilder(Challenge instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Challenge());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  ChallengeFluent<?> fluent;
  Boolean validationEnabled;
  public Challenge build() {
    Challenge buildable = new Challenge(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}