package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateDNSNameSelectorBuilder extends CertificateDNSNameSelectorFluent<CertificateDNSNameSelectorBuilder> implements VisitableBuilder<CertificateDNSNameSelector,CertificateDNSNameSelectorBuilder>{
  public CertificateDNSNameSelectorBuilder() {
    this(false);
  }
  public CertificateDNSNameSelectorBuilder(Boolean validationEnabled) {
    this(new CertificateDNSNameSelector(), validationEnabled);
  }
  public CertificateDNSNameSelectorBuilder(CertificateDNSNameSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateDNSNameSelectorBuilder(CertificateDNSNameSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateDNSNameSelector(), validationEnabled);
  }
  public CertificateDNSNameSelectorBuilder(CertificateDNSNameSelectorFluent<?> fluent,CertificateDNSNameSelector instance) {
    this(fluent, instance, false);
  }
  public CertificateDNSNameSelectorBuilder(CertificateDNSNameSelectorFluent<?> fluent,CertificateDNSNameSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertificateDNSNameSelector());

    if (instance != null) {
      fluent.withDnsNames(instance.getDnsNames());
      fluent.withDnsZones(instance.getDnsZones());
      fluent.withMatchLabels(instance.getMatchLabels());
      fluent.withDnsNames(instance.getDnsNames());
      fluent.withDnsZones(instance.getDnsZones());
      fluent.withMatchLabels(instance.getMatchLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertificateDNSNameSelectorBuilder(CertificateDNSNameSelector instance) {
    this(instance,false);
  }
  public CertificateDNSNameSelectorBuilder(CertificateDNSNameSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertificateDNSNameSelector());

    if (instance != null) {
      this.withDnsNames(instance.getDnsNames());
      this.withDnsZones(instance.getDnsZones());
      this.withMatchLabels(instance.getMatchLabels());
      this.withDnsNames(instance.getDnsNames());
      this.withDnsZones(instance.getDnsZones());
      this.withMatchLabels(instance.getMatchLabels());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertificateDNSNameSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateDNSNameSelector build() {
    CertificateDNSNameSelector buildable = new CertificateDNSNameSelector(fluent.getDnsNames(),fluent.getDnsZones(),fluent.getMatchLabels());
    return buildable;
  }
  
}