package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AzureManagedIdentityBuilder extends AzureManagedIdentityFluent<AzureManagedIdentityBuilder> implements VisitableBuilder<AzureManagedIdentity,AzureManagedIdentityBuilder>{
  public AzureManagedIdentityBuilder() {
    this(false);
  }
  public AzureManagedIdentityBuilder(Boolean validationEnabled) {
    this(new AzureManagedIdentity(), validationEnabled);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent) {
    this(fluent, false);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AzureManagedIdentity(), validationEnabled);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent,AzureManagedIdentity instance) {
    this(fluent, instance, false);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentityFluent<?> fluent,AzureManagedIdentity instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AzureManagedIdentity());

    if (instance != null) {
      fluent.withClientID(instance.getClientID());
      fluent.withResourceID(instance.getResourceID());
      fluent.withClientID(instance.getClientID());
      fluent.withResourceID(instance.getResourceID());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentity instance) {
    this(instance,false);
  }
  public AzureManagedIdentityBuilder(AzureManagedIdentity instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AzureManagedIdentity());

    if (instance != null) {
      this.withClientID(instance.getClientID());
      this.withResourceID(instance.getResourceID());
      this.withClientID(instance.getClientID());
      this.withResourceID(instance.getResourceID());
    }
    this.validationEnabled = validationEnabled; 
  }
  AzureManagedIdentityFluent<?> fluent;
  Boolean validationEnabled;
  public AzureManagedIdentity build() {
    AzureManagedIdentity buildable = new AzureManagedIdentity(fluent.getClientID(),fluent.getResourceID());
    return buildable;
  }
  
}