package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Object;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerDNS01ProviderRoute53Fluent<A extends ACMEIssuerDNS01ProviderRoute53Fluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderRoute53Fluent() {
  }
  public ACMEIssuerDNS01ProviderRoute53Fluent(ACMEIssuerDNS01ProviderRoute53 instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderRoute53());

    if (instance != null) {
      this.withAccessKeyID(instance.getAccessKeyID());
      this.withHostedZoneID(instance.getHostedZoneID());
      this.withRegion(instance.getRegion());
      this.withRole(instance.getRole());
      this.withSecretAccessKeySecretRef(instance.getSecretAccessKeySecretRef());
      this.withAccessKeyID(instance.getAccessKeyID());
      this.withHostedZoneID(instance.getHostedZoneID());
      this.withRegion(instance.getRegion());
      this.withRole(instance.getRole());
      this.withSecretAccessKeySecretRef(instance.getSecretAccessKeySecretRef());
    }
  }
  private String accessKeyID;
  private String hostedZoneID;
  private String region;
  private String role;
  private SecretKeySelectorBuilder secretAccessKeySecretRef;
  public String getAccessKeyID() {
    return this.accessKeyID;
  }
  public A withAccessKeyID(String accessKeyID) {
    this.accessKeyID=accessKeyID; return (A) this;
  }
  public boolean hasAccessKeyID() {
    return this.accessKeyID != null;
  }
  public String getHostedZoneID() {
    return this.hostedZoneID;
  }
  public A withHostedZoneID(String hostedZoneID) {
    this.hostedZoneID=hostedZoneID; return (A) this;
  }
  public boolean hasHostedZoneID() {
    return this.hostedZoneID != null;
  }
  public String getRegion() {
    return this.region;
  }
  public A withRegion(String region) {
    this.region=region; return (A) this;
  }
  public boolean hasRegion() {
    return this.region != null;
  }
  public String getRole() {
    return this.role;
  }
  public A withRole(String role) {
    this.role=role; return (A) this;
  }
  public boolean hasRole() {
    return this.role != null;
  }
  public SecretKeySelector buildSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef!=null ?this.secretAccessKeySecretRef.build():null;
  }
  public A withSecretAccessKeySecretRef(SecretKeySelector secretAccessKeySecretRef) {
    _visitables.get("secretAccessKeySecretRef").remove(this.secretAccessKeySecretRef);
    if (secretAccessKeySecretRef!=null){ this.secretAccessKeySecretRef= new SecretKeySelectorBuilder(secretAccessKeySecretRef); _visitables.get("secretAccessKeySecretRef").add(this.secretAccessKeySecretRef);} else { this.secretAccessKeySecretRef = null; _visitables.get("secretAccessKeySecretRef").remove(this.secretAccessKeySecretRef); } return (A) this;
  }
  public boolean hasSecretAccessKeySecretRef() {
    return this.secretAccessKeySecretRef != null;
  }
  public A withNewSecretAccessKeySecretRef(String key,String name) {
    return (A)withSecretAccessKeySecretRef(new SecretKeySelector(key, name));
  }
  public SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRef() {
    return new SecretAccessKeySecretRefNested(null);
  }
  public SecretAccessKeySecretRefNested<A> withNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return new SecretAccessKeySecretRefNested(item);
  }
  public SecretAccessKeySecretRefNested<A> editSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(null));
  }
  public SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRef() {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  public SecretAccessKeySecretRefNested<A> editOrNewSecretAccessKeySecretRefLike(SecretKeySelector item) {
    return withNewSecretAccessKeySecretRefLike(java.util.Optional.ofNullable(buildSecretAccessKeySecretRef()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderRoute53Fluent that = (ACMEIssuerDNS01ProviderRoute53Fluent) o;
    if (!java.util.Objects.equals(accessKeyID, that.accessKeyID)) return false;

    if (!java.util.Objects.equals(hostedZoneID, that.hostedZoneID)) return false;

    if (!java.util.Objects.equals(region, that.region)) return false;

    if (!java.util.Objects.equals(role, that.role)) return false;

    if (!java.util.Objects.equals(secretAccessKeySecretRef, that.secretAccessKeySecretRef)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(accessKeyID,  hostedZoneID,  region,  role,  secretAccessKeySecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (accessKeyID != null) { sb.append("accessKeyID:"); sb.append(accessKeyID + ","); }
    if (hostedZoneID != null) { sb.append("hostedZoneID:"); sb.append(hostedZoneID + ","); }
    if (region != null) { sb.append("region:"); sb.append(region + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (secretAccessKeySecretRef != null) { sb.append("secretAccessKeySecretRef:"); sb.append(secretAccessKeySecretRef); }
    sb.append("}");
    return sb.toString();
  }
  public class SecretAccessKeySecretRefNested<N> extends SecretKeySelectorFluent<SecretAccessKeySecretRefNested<N>> implements Nested<N>{
    SecretAccessKeySecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerDNS01ProviderRoute53Fluent.this.withSecretAccessKeySecretRef(builder.build());
    }
    public N endSecretAccessKeySecretRef() {
      return and();
    }
    
  }
  
}