package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEIssuerDNS01ProviderCloudflareBuilder extends ACMEIssuerDNS01ProviderCloudflareFluent<ACMEIssuerDNS01ProviderCloudflareBuilder> implements VisitableBuilder<ACMEIssuerDNS01ProviderCloudflare,ACMEIssuerDNS01ProviderCloudflareBuilder>{
  public ACMEIssuerDNS01ProviderCloudflareBuilder() {
    this(false);
  }
  public ACMEIssuerDNS01ProviderCloudflareBuilder(Boolean validationEnabled) {
    this(new ACMEIssuerDNS01ProviderCloudflare(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderCloudflareBuilder(ACMEIssuerDNS01ProviderCloudflareFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEIssuerDNS01ProviderCloudflareBuilder(ACMEIssuerDNS01ProviderCloudflareFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEIssuerDNS01ProviderCloudflare(), validationEnabled);
  }
  public ACMEIssuerDNS01ProviderCloudflareBuilder(ACMEIssuerDNS01ProviderCloudflareFluent<?> fluent,ACMEIssuerDNS01ProviderCloudflare instance) {
    this(fluent, instance, false);
  }
  public ACMEIssuerDNS01ProviderCloudflareBuilder(ACMEIssuerDNS01ProviderCloudflareFluent<?> fluent,ACMEIssuerDNS01ProviderCloudflare instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderCloudflare());

    if (instance != null) {
      fluent.withApiKeySecretRef(instance.getApiKeySecretRef());
      fluent.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      fluent.withEmail(instance.getEmail());
      fluent.withApiKeySecretRef(instance.getApiKeySecretRef());
      fluent.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      fluent.withEmail(instance.getEmail());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEIssuerDNS01ProviderCloudflareBuilder(ACMEIssuerDNS01ProviderCloudflare instance) {
    this(instance,false);
  }
  public ACMEIssuerDNS01ProviderCloudflareBuilder(ACMEIssuerDNS01ProviderCloudflare instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderCloudflare());

    if (instance != null) {
      this.withApiKeySecretRef(instance.getApiKeySecretRef());
      this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      this.withEmail(instance.getEmail());
      this.withApiKeySecretRef(instance.getApiKeySecretRef());
      this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
      this.withEmail(instance.getEmail());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEIssuerDNS01ProviderCloudflareFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEIssuerDNS01ProviderCloudflare build() {
    ACMEIssuerDNS01ProviderCloudflare buildable = new ACMEIssuerDNS01ProviderCloudflare(fluent.buildApiKeySecretRef(),fluent.buildApiTokenSecretRef(),fluent.getEmail());
    return buildable;
  }
  
}