package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEChallengeBuilder extends ACMEChallengeFluent<ACMEChallengeBuilder> implements VisitableBuilder<ACMEChallenge,ACMEChallengeBuilder>{
  public ACMEChallengeBuilder() {
    this(false);
  }
  public ACMEChallengeBuilder(Boolean validationEnabled) {
    this(new ACMEChallenge(), validationEnabled);
  }
  public ACMEChallengeBuilder(ACMEChallengeFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEChallengeBuilder(ACMEChallengeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ACMEChallenge(), validationEnabled);
  }
  public ACMEChallengeBuilder(ACMEChallengeFluent<?> fluent,ACMEChallenge instance) {
    this(fluent, instance, false);
  }
  public ACMEChallengeBuilder(ACMEChallengeFluent<?> fluent,ACMEChallenge instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ACMEChallenge());

    if (instance != null) {
      fluent.withToken(instance.getToken());
      fluent.withType(instance.getType());
      fluent.withUrl(instance.getUrl());
      fluent.withToken(instance.getToken());
      fluent.withType(instance.getType());
      fluent.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ACMEChallengeBuilder(ACMEChallenge instance) {
    this(instance,false);
  }
  public ACMEChallengeBuilder(ACMEChallenge instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ACMEChallenge());

    if (instance != null) {
      this.withToken(instance.getToken());
      this.withType(instance.getType());
      this.withUrl(instance.getUrl());
      this.withToken(instance.getToken());
      this.withType(instance.getType());
      this.withUrl(instance.getUrl());
    }
    this.validationEnabled = validationEnabled; 
  }
  ACMEChallengeFluent<?> fluent;
  Boolean validationEnabled;
  public ACMEChallenge build() {
    ACMEChallenge buildable = new ACMEChallenge(fluent.getToken(),fluent.getType(),fluent.getUrl());
    return buildable;
  }
  
}