package io.fabric8.certmanager.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertmanagerSchemaBuilder extends CertmanagerSchemaFluent<CertmanagerSchemaBuilder> implements VisitableBuilder<CertmanagerSchema,CertmanagerSchemaBuilder>{
  public CertmanagerSchemaBuilder() {
    this(false);
  }
  public CertmanagerSchemaBuilder(Boolean validationEnabled) {
    this(new CertmanagerSchema(), validationEnabled);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent) {
    this(fluent, false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertmanagerSchema(), validationEnabled);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance) {
    this(fluent, instance, false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CertmanagerSchema());

    if (instance != null) {
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec());
      fluent.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP());
      fluent.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      fluent.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CertmanagerSchemaBuilder(CertmanagerSchema instance) {
    this(instance,false);
  }
  public CertmanagerSchemaBuilder(CertmanagerSchema instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CertmanagerSchema());

    if (instance != null) {
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject());
      this.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec());
      this.withGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(instance.getGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP());
      this.withGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(instance.getGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject());
      this.withGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(instance.getGithubComJetstackCertManagerPkgApisMetaV1ObjectReference());
      this.withGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector(instance.getGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    }
    this.validationEnabled = validationEnabled; 
  }
  CertmanagerSchemaFluent<?> fluent;
  Boolean validationEnabled;
  public CertmanagerSchema build() {
    CertmanagerSchema buildable = new CertmanagerSchema(fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    return buildable;
  }
  
}