/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorizationFluent;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallenge;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeBuilder;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ACMEAuthorizationFluentImpl<A extends ACMEAuthorizationFluent<A>>
extends BaseFluent<A>
implements ACMEAuthorizationFluent<A> {
    private ArrayList<ACMEChallengeBuilder> challenges = new ArrayList();
    private String identifier;
    private String initialState;
    private String url;
    private Boolean wildcard;

    public ACMEAuthorizationFluentImpl() {
    }

    public ACMEAuthorizationFluentImpl(ACMEAuthorization instance) {
        this.withChallenges(instance.getChallenges());
        this.withIdentifier(instance.getIdentifier());
        this.withInitialState(instance.getInitialState());
        this.withUrl(instance.getUrl());
        this.withWildcard(instance.getWildcard());
    }

    @Override
    public A addToChallenges(Integer index, ACMEChallenge item) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
        this._visitables.get((Object)"challenges").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"challenges").size(), builder);
        this.challenges.add(index >= 0 ? index.intValue() : this.challenges.size(), builder);
        return (A)this;
    }

    @Override
    public A setToChallenges(Integer index, ACMEChallenge item) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"challenges").size()) {
            this._visitables.get((Object)"challenges").add(builder);
        } else {
            this._visitables.get((Object)"challenges").set(index, builder);
        }
        if (index < 0 || index >= this.challenges.size()) {
            this.challenges.add(builder);
        } else {
            this.challenges.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToChallenges(ACMEChallenge ... items) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToChallenges(Collection<ACMEChallenge> items) {
        if (this.challenges == null) {
            this.challenges = new ArrayList();
        }
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").add(builder);
            this.challenges.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromChallenges(ACMEChallenge ... items) {
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").remove(builder);
            if (this.challenges == null) continue;
            this.challenges.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromChallenges(Collection<ACMEChallenge> items) {
        for (ACMEChallenge item : items) {
            ACMEChallengeBuilder builder = new ACMEChallengeBuilder(item);
            this._visitables.get((Object)"challenges").remove(builder);
            if (this.challenges == null) continue;
            this.challenges.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromChallenges(Predicate<ACMEChallengeBuilder> predicate) {
        if (this.challenges == null) {
            return (A)this;
        }
        Iterator<ACMEChallengeBuilder> each = this.challenges.iterator();
        List visitables = this._visitables.get((Object)"challenges");
        while (each.hasNext()) {
            ACMEChallengeBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ACMEChallenge> getChallenges() {
        return this.challenges != null ? ACMEAuthorizationFluentImpl.build(this.challenges) : null;
    }

    @Override
    public List<ACMEChallenge> buildChallenges() {
        return this.challenges != null ? ACMEAuthorizationFluentImpl.build(this.challenges) : null;
    }

    @Override
    public ACMEChallenge buildChallenge(Integer index) {
        return this.challenges.get(index).build();
    }

    @Override
    public ACMEChallenge buildFirstChallenge() {
        return this.challenges.get(0).build();
    }

    @Override
    public ACMEChallenge buildLastChallenge() {
        return this.challenges.get(this.challenges.size() - 1).build();
    }

    @Override
    public ACMEChallenge buildMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        for (ACMEChallengeBuilder item : this.challenges) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        for (ACMEChallengeBuilder item : this.challenges) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withChallenges(List<ACMEChallenge> challenges) {
        if (this.challenges != null) {
            this._visitables.get((Object)"challenges").removeAll(this.challenges);
        }
        if (challenges != null) {
            this.challenges = new ArrayList();
            for (ACMEChallenge item : challenges) {
                this.addToChallenges(item);
            }
        } else {
            this.challenges = null;
        }
        return (A)this;
    }

    @Override
    public A withChallenges(ACMEChallenge ... challenges) {
        if (this.challenges != null) {
            this.challenges.clear();
        }
        if (challenges != null) {
            for (ACMEChallenge item : challenges) {
                this.addToChallenges(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasChallenges() {
        return this.challenges != null && !this.challenges.isEmpty();
    }

    @Override
    public A addNewChallenge(String token, String type, String url) {
        return this.addToChallenges(new ACMEChallenge(token, type, url));
    }

    @Override
    public ACMEAuthorizationFluent.ChallengesNested<A> addNewChallenge() {
        return new ChallengesNestedImpl();
    }

    @Override
    public ACMEAuthorizationFluent.ChallengesNested<A> addNewChallengeLike(ACMEChallenge item) {
        return new ChallengesNestedImpl(-1, item);
    }

    @Override
    public ACMEAuthorizationFluent.ChallengesNested<A> setNewChallengeLike(Integer index, ACMEChallenge item) {
        return new ChallengesNestedImpl(index, item);
    }

    @Override
    public ACMEAuthorizationFluent.ChallengesNested<A> editChallenge(Integer index) {
        if (this.challenges.size() <= index) {
            throw new RuntimeException("Can't edit challenges. Index exceeds size.");
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    @Override
    public ACMEAuthorizationFluent.ChallengesNested<A> editFirstChallenge() {
        if (this.challenges.size() == 0) {
            throw new RuntimeException("Can't edit first challenges. The list is empty.");
        }
        return this.setNewChallengeLike(0, this.buildChallenge(0));
    }

    @Override
    public ACMEAuthorizationFluent.ChallengesNested<A> editLastChallenge() {
        int index = this.challenges.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last challenges. The list is empty.");
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    @Override
    public ACMEAuthorizationFluent.ChallengesNested<A> editMatchingChallenge(Predicate<ACMEChallengeBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.challenges.size(); ++i) {
            if (!predicate.test(this.challenges.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching challenges. No match found.");
        }
        return this.setNewChallengeLike(index, this.buildChallenge(index));
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public A withIdentifier(String identifier) {
        this.identifier = identifier;
        return (A)this;
    }

    @Override
    public Boolean hasIdentifier() {
        return this.identifier != null;
    }

    @Override
    public String getInitialState() {
        return this.initialState;
    }

    @Override
    public A withInitialState(String initialState) {
        this.initialState = initialState;
        return (A)this;
    }

    @Override
    public Boolean hasInitialState() {
        return this.initialState != null;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public Boolean getWildcard() {
        return this.wildcard;
    }

    @Override
    public A withWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
        return (A)this;
    }

    @Override
    public Boolean hasWildcard() {
        return this.wildcard != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ACMEAuthorizationFluentImpl that = (ACMEAuthorizationFluentImpl)o;
        if (this.challenges != null ? !this.challenges.equals(that.challenges) : that.challenges != null) {
            return false;
        }
        if (this.identifier != null ? !this.identifier.equals(that.identifier) : that.identifier != null) {
            return false;
        }
        if (this.initialState != null ? !this.initialState.equals(that.initialState) : that.initialState != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.wildcard != null ? !this.wildcard.equals(that.wildcard) : that.wildcard != null);
    }

    public int hashCode() {
        return Objects.hash(this.challenges, this.identifier, this.initialState, this.url, this.wildcard, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.challenges != null && !this.challenges.isEmpty()) {
            sb.append("challenges:");
            sb.append(this.challenges + ",");
        }
        if (this.identifier != null) {
            sb.append("identifier:");
            sb.append(this.identifier + ",");
        }
        if (this.initialState != null) {
            sb.append("initialState:");
            sb.append(this.initialState + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.wildcard != null) {
            sb.append("wildcard:");
            sb.append(this.wildcard);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withWildcard() {
        return this.withWildcard(true);
    }

    class ChallengesNestedImpl<N>
    extends ACMEChallengeFluentImpl<ACMEAuthorizationFluent.ChallengesNested<N>>
    implements ACMEAuthorizationFluent.ChallengesNested<N>,
    Nested<N> {
        ACMEChallengeBuilder builder;
        Integer index;

        ChallengesNestedImpl(Integer index, ACMEChallenge item) {
            this.index = index;
            this.builder = new ACMEChallengeBuilder(this, item);
        }

        ChallengesNestedImpl() {
            this.index = -1;
            this.builder = new ACMEChallengeBuilder(this);
        }

        @Override
        public N and() {
            return (N)ACMEAuthorizationFluentImpl.this.setToChallenges(this.index, this.builder.build());
        }

        @Override
        public N endChallenge() {
            return this.and();
        }
    }
}

