package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultIssuerBuilder extends VaultIssuerFluentImpl<VaultIssuerBuilder> implements VisitableBuilder<VaultIssuer,VaultIssuerBuilder>{
  public VaultIssuerBuilder() {
    this(false);
  }
  public VaultIssuerBuilder(Boolean validationEnabled) {
    this(new VaultIssuer(), validationEnabled);
  }
  public VaultIssuerBuilder(VaultIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultIssuerBuilder(VaultIssuerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VaultIssuer(), validationEnabled);
  }
  public VaultIssuerBuilder(VaultIssuerFluent<?> fluent,VaultIssuer instance) {
    this(fluent, instance, false);
  }
  public VaultIssuerBuilder(VaultIssuerFluent<?> fluent,VaultIssuer instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuth(instance.getAuth()); 
    fluent.withCaBundle(instance.getCaBundle()); 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withPath(instance.getPath()); 
    fluent.withServer(instance.getServer()); 
    this.validationEnabled = validationEnabled; 
  }
  public VaultIssuerBuilder(VaultIssuer instance) {
    this(instance,false);
  }
  public VaultIssuerBuilder(VaultIssuer instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuth(instance.getAuth()); 
    this.withCaBundle(instance.getCaBundle()); 
    this.withNamespace(instance.getNamespace()); 
    this.withPath(instance.getPath()); 
    this.withServer(instance.getServer()); 
    this.validationEnabled = validationEnabled; 
  }
  VaultIssuerFluent<?> fluent;
  Boolean validationEnabled;
  public VaultIssuer build() {
    VaultIssuer buildable = new VaultIssuer(fluent.getAuth(),fluent.getCaBundle(),fluent.getNamespace(),fluent.getPath(),fluent.getServer());
    return buildable;
  }
  
}