/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAppRole;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleFluentImpl;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAuth;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAuthFluent;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuth;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuthBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuthFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;

public class VaultAuthFluentImpl<A extends VaultAuthFluent<A>>
extends BaseFluent<A>
implements VaultAuthFluent<A> {
    private VaultAppRoleBuilder appRole;
    private VaultKubernetesAuthBuilder kubernetes;
    private SecretKeySelectorBuilder tokenSecretRef;

    public VaultAuthFluentImpl() {
    }

    public VaultAuthFluentImpl(VaultAuth instance) {
        this.withAppRole(instance.getAppRole());
        this.withKubernetes(instance.getKubernetes());
        this.withTokenSecretRef(instance.getTokenSecretRef());
    }

    @Override
    @Deprecated
    public VaultAppRole getAppRole() {
        return this.appRole != null ? this.appRole.build() : null;
    }

    @Override
    public VaultAppRole buildAppRole() {
        return this.appRole != null ? this.appRole.build() : null;
    }

    @Override
    public A withAppRole(VaultAppRole appRole) {
        this._visitables.get((Object)"appRole").remove(this.appRole);
        if (appRole != null) {
            this.appRole = new VaultAppRoleBuilder(appRole);
            this._visitables.get((Object)"appRole").add(this.appRole);
        } else {
            this.appRole = null;
            this._visitables.get((Object)"appRole").remove(this.appRole);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAppRole() {
        return this.appRole != null;
    }

    @Override
    public VaultAuthFluent.AppRoleNested<A> withNewAppRole() {
        return new AppRoleNestedImpl();
    }

    @Override
    public VaultAuthFluent.AppRoleNested<A> withNewAppRoleLike(VaultAppRole item) {
        return new AppRoleNestedImpl(item);
    }

    @Override
    public VaultAuthFluent.AppRoleNested<A> editAppRole() {
        return this.withNewAppRoleLike(this.getAppRole());
    }

    @Override
    public VaultAuthFluent.AppRoleNested<A> editOrNewAppRole() {
        return this.withNewAppRoleLike(this.getAppRole() != null ? this.getAppRole() : new VaultAppRoleBuilder().build());
    }

    @Override
    public VaultAuthFluent.AppRoleNested<A> editOrNewAppRoleLike(VaultAppRole item) {
        return this.withNewAppRoleLike(this.getAppRole() != null ? this.getAppRole() : item);
    }

    @Override
    @Deprecated
    public VaultKubernetesAuth getKubernetes() {
        return this.kubernetes != null ? this.kubernetes.build() : null;
    }

    @Override
    public VaultKubernetesAuth buildKubernetes() {
        return this.kubernetes != null ? this.kubernetes.build() : null;
    }

    @Override
    public A withKubernetes(VaultKubernetesAuth kubernetes) {
        this._visitables.get((Object)"kubernetes").remove(this.kubernetes);
        if (kubernetes != null) {
            this.kubernetes = new VaultKubernetesAuthBuilder(kubernetes);
            this._visitables.get((Object)"kubernetes").add(this.kubernetes);
        } else {
            this.kubernetes = null;
            this._visitables.get((Object)"kubernetes").remove(this.kubernetes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasKubernetes() {
        return this.kubernetes != null;
    }

    @Override
    public VaultAuthFluent.KubernetesNested<A> withNewKubernetes() {
        return new KubernetesNestedImpl();
    }

    @Override
    public VaultAuthFluent.KubernetesNested<A> withNewKubernetesLike(VaultKubernetesAuth item) {
        return new KubernetesNestedImpl(item);
    }

    @Override
    public VaultAuthFluent.KubernetesNested<A> editKubernetes() {
        return this.withNewKubernetesLike(this.getKubernetes());
    }

    @Override
    public VaultAuthFluent.KubernetesNested<A> editOrNewKubernetes() {
        return this.withNewKubernetesLike(this.getKubernetes() != null ? this.getKubernetes() : new VaultKubernetesAuthBuilder().build());
    }

    @Override
    public VaultAuthFluent.KubernetesNested<A> editOrNewKubernetesLike(VaultKubernetesAuth item) {
        return this.withNewKubernetesLike(this.getKubernetes() != null ? this.getKubernetes() : item);
    }

    @Override
    @Deprecated
    public SecretKeySelector getTokenSecretRef() {
        return this.tokenSecretRef != null ? this.tokenSecretRef.build() : null;
    }

    @Override
    public SecretKeySelector buildTokenSecretRef() {
        return this.tokenSecretRef != null ? this.tokenSecretRef.build() : null;
    }

    @Override
    public A withTokenSecretRef(SecretKeySelector tokenSecretRef) {
        this._visitables.get((Object)"tokenSecretRef").remove(this.tokenSecretRef);
        if (tokenSecretRef != null) {
            this.tokenSecretRef = new SecretKeySelectorBuilder(tokenSecretRef);
            this._visitables.get((Object)"tokenSecretRef").add(this.tokenSecretRef);
        } else {
            this.tokenSecretRef = null;
            this._visitables.get((Object)"tokenSecretRef").remove(this.tokenSecretRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTokenSecretRef() {
        return this.tokenSecretRef != null;
    }

    @Override
    public A withNewTokenSecretRef(String key, String name) {
        return this.withTokenSecretRef(new SecretKeySelector(key, name));
    }

    @Override
    public VaultAuthFluent.TokenSecretRefNested<A> withNewTokenSecretRef() {
        return new TokenSecretRefNestedImpl();
    }

    @Override
    public VaultAuthFluent.TokenSecretRefNested<A> withNewTokenSecretRefLike(SecretKeySelector item) {
        return new TokenSecretRefNestedImpl(item);
    }

    @Override
    public VaultAuthFluent.TokenSecretRefNested<A> editTokenSecretRef() {
        return this.withNewTokenSecretRefLike(this.getTokenSecretRef());
    }

    @Override
    public VaultAuthFluent.TokenSecretRefNested<A> editOrNewTokenSecretRef() {
        return this.withNewTokenSecretRefLike(this.getTokenSecretRef() != null ? this.getTokenSecretRef() : new SecretKeySelectorBuilder().build());
    }

    @Override
    public VaultAuthFluent.TokenSecretRefNested<A> editOrNewTokenSecretRefLike(SecretKeySelector item) {
        return this.withNewTokenSecretRefLike(this.getTokenSecretRef() != null ? this.getTokenSecretRef() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VaultAuthFluentImpl that = (VaultAuthFluentImpl)o;
        if (this.appRole != null ? !this.appRole.equals(that.appRole) : that.appRole != null) {
            return false;
        }
        if (this.kubernetes != null ? !this.kubernetes.equals(that.kubernetes) : that.kubernetes != null) {
            return false;
        }
        return !(this.tokenSecretRef != null ? !this.tokenSecretRef.equals(that.tokenSecretRef) : that.tokenSecretRef != null);
    }

    public int hashCode() {
        return Objects.hash(this.appRole, this.kubernetes, this.tokenSecretRef, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appRole != null) {
            sb.append("appRole:");
            sb.append(this.appRole + ",");
        }
        if (this.kubernetes != null) {
            sb.append("kubernetes:");
            sb.append(this.kubernetes + ",");
        }
        if (this.tokenSecretRef != null) {
            sb.append("tokenSecretRef:");
            sb.append(this.tokenSecretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    class TokenSecretRefNestedImpl<N>
    extends SecretKeySelectorFluentImpl<VaultAuthFluent.TokenSecretRefNested<N>>
    implements VaultAuthFluent.TokenSecretRefNested<N>,
    Nested<N> {
        SecretKeySelectorBuilder builder;

        TokenSecretRefNestedImpl(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        TokenSecretRefNestedImpl() {
            this.builder = new SecretKeySelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultAuthFluentImpl.this.withTokenSecretRef(this.builder.build());
        }

        @Override
        public N endTokenSecretRef() {
            return this.and();
        }
    }

    class KubernetesNestedImpl<N>
    extends VaultKubernetesAuthFluentImpl<VaultAuthFluent.KubernetesNested<N>>
    implements VaultAuthFluent.KubernetesNested<N>,
    Nested<N> {
        VaultKubernetesAuthBuilder builder;

        KubernetesNestedImpl(VaultKubernetesAuth item) {
            this.builder = new VaultKubernetesAuthBuilder(this, item);
        }

        KubernetesNestedImpl() {
            this.builder = new VaultKubernetesAuthBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultAuthFluentImpl.this.withKubernetes(this.builder.build());
        }

        @Override
        public N endKubernetes() {
            return this.and();
        }
    }

    class AppRoleNestedImpl<N>
    extends VaultAppRoleFluentImpl<VaultAuthFluent.AppRoleNested<N>>
    implements VaultAuthFluent.AppRoleNested<N>,
    Nested<N> {
        VaultAppRoleBuilder builder;

        AppRoleNestedImpl(VaultAppRole item) {
            this.builder = new VaultAppRoleBuilder(this, item);
        }

        AppRoleNestedImpl() {
            this.builder = new VaultAppRoleBuilder(this);
        }

        @Override
        public N and() {
            return (N)VaultAuthFluentImpl.this.withAppRole(this.builder.build());
        }

        @Override
        public N endAppRole() {
            return this.and();
        }
    }
}

