package io.fabric8.certmanager.api.model.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class VaultKubernetesAuthFluentImpl<A extends VaultKubernetesAuthFluent<A>> extends BaseFluent<A> implements VaultKubernetesAuthFluent<A>{
  public VaultKubernetesAuthFluentImpl() {
  }
  public VaultKubernetesAuthFluentImpl(VaultKubernetesAuth instance) {
    this.withMountPath(instance.getMountPath()); 
    this.withRole(instance.getRole()); 
    this.withSecretRef(instance.getSecretRef()); 
  }
  private String mountPath;
  private String role;
  private SecretKeySelectorBuilder secretRef;
  public String getMountPath() {
    return this.mountPath;
  }
  public A withMountPath(String mountPath) {
    this.mountPath=mountPath; return (A) this;
  }
  public Boolean hasMountPath() {
    return this.mountPath != null;
  }
  public String getRole() {
    return this.role;
  }
  public A withRole(String role) {
    this.role=role; return (A) this;
  }
  public Boolean hasRole() {
    return this.role != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public SecretKeySelector buildSecretRef() {
    return this.secretRef!=null ?this.secretRef.build():null;
  }
  public A withSecretRef(SecretKeySelector secretRef) {
    _visitables.get("secretRef").remove(this.secretRef);
    if (secretRef!=null){ this.secretRef= new SecretKeySelectorBuilder(secretRef); _visitables.get("secretRef").add(this.secretRef);} else { this.secretRef = null; _visitables.get("secretRef").remove(this.secretRef); } return (A) this;
  }
  public Boolean hasSecretRef() {
    return this.secretRef != null;
  }
  public A withNewSecretRef(String key,String name) {
    return (A)withSecretRef(new SecretKeySelector(key, name));
  }
  public VaultKubernetesAuthFluent.SecretRefNested<A> withNewSecretRef() {
    return new VaultKubernetesAuthFluentImpl.SecretRefNestedImpl();
  }
  public VaultKubernetesAuthFluent.SecretRefNested<A> withNewSecretRefLike(SecretKeySelector item) {
    return new VaultKubernetesAuthFluentImpl.SecretRefNestedImpl(item);
  }
  public VaultKubernetesAuthFluent.SecretRefNested<A> editSecretRef() {
    return withNewSecretRefLike(getSecretRef());
  }
  public VaultKubernetesAuthFluent.SecretRefNested<A> editOrNewSecretRef() {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): new SecretKeySelectorBuilder().build());
  }
  public VaultKubernetesAuthFluent.SecretRefNested<A> editOrNewSecretRefLike(SecretKeySelector item) {
    return withNewSecretRefLike(getSecretRef() != null ? getSecretRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    VaultKubernetesAuthFluentImpl that = (VaultKubernetesAuthFluentImpl) o;
    if (mountPath != null ? !mountPath.equals(that.mountPath) :that.mountPath != null) return false;
    if (role != null ? !role.equals(that.role) :that.role != null) return false;
    if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(mountPath,  role,  secretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (mountPath != null) { sb.append("mountPath:"); sb.append(mountPath + ","); }
    if (role != null) { sb.append("role:"); sb.append(role + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef); }
    sb.append("}");
    return sb.toString();
  }
  class SecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<VaultKubernetesAuthFluent.SecretRefNested<N>> implements VaultKubernetesAuthFluent.SecretRefNested<N>,Nested<N>{
    SecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) VaultKubernetesAuthFluentImpl.this.withSecretRef(builder.build());
    }
    public N endSecretRef() {
      return and();
    }
    
  }
  
}