package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerStatusBuilder;
import java.util.function.Predicate;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerStatus;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerStatusFluentImpl;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IssuerStatusFluentImpl<A extends IssuerStatusFluent<A>> extends BaseFluent<A> implements IssuerStatusFluent<A>{
  public IssuerStatusFluentImpl() {
  }
  public IssuerStatusFluentImpl(IssuerStatus instance) {
    this.withAcme(instance.getAcme()); 
    this.withConditions(instance.getConditions()); 
  }
  private ACMEIssuerStatusBuilder acme;
  private ArrayList<IssuerConditionBuilder> conditions = new ArrayList<IssuerConditionBuilder>();
  
  /**
   * This method has been deprecated, please use method buildAcme instead.
   * @return The buildable object.
   */
  @Deprecated
  public ACMEIssuerStatus getAcme() {
    return this.acme!=null ?this.acme.build():null;
  }
  public ACMEIssuerStatus buildAcme() {
    return this.acme!=null ?this.acme.build():null;
  }
  public A withAcme(ACMEIssuerStatus acme) {
    _visitables.get("acme").remove(this.acme);
    if (acme!=null){ this.acme= new ACMEIssuerStatusBuilder(acme); _visitables.get("acme").add(this.acme);} else { this.acme = null; _visitables.get("acme").remove(this.acme); } return (A) this;
  }
  public Boolean hasAcme() {
    return this.acme != null;
  }
  public A withNewAcme(String lastRegisteredEmail,String uri) {
    return (A)withAcme(new ACMEIssuerStatus(lastRegisteredEmail, uri));
  }
  public IssuerStatusFluent.AcmeNested<A> withNewAcme() {
    return new IssuerStatusFluentImpl.AcmeNestedImpl();
  }
  public IssuerStatusFluent.AcmeNested<A> withNewAcmeLike(ACMEIssuerStatus item) {
    return new IssuerStatusFluentImpl.AcmeNestedImpl(item);
  }
  public IssuerStatusFluent.AcmeNested<A> editAcme() {
    return withNewAcmeLike(getAcme());
  }
  public IssuerStatusFluent.AcmeNested<A> editOrNewAcme() {
    return withNewAcmeLike(getAcme() != null ? getAcme(): new ACMEIssuerStatusBuilder().build());
  }
  public IssuerStatusFluent.AcmeNested<A> editOrNewAcmeLike(ACMEIssuerStatus item) {
    return withNewAcmeLike(getAcme() != null ? getAcme(): item);
  }
  public A addToConditions(Integer index,IssuerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IssuerConditionBuilder>();}
    IssuerConditionBuilder builder = new IssuerConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(Integer index,IssuerCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<IssuerConditionBuilder>();}
    IssuerConditionBuilder builder = new IssuerConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.certmanager.api.model.v1alpha3.IssuerCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IssuerConditionBuilder>();}
    for (IssuerCondition item : items) {IssuerConditionBuilder builder = new IssuerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<IssuerCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<IssuerConditionBuilder>();}
    for (IssuerCondition item : items) {IssuerConditionBuilder builder = new IssuerConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.certmanager.api.model.v1alpha3.IssuerCondition... items) {
    for (IssuerCondition item : items) {IssuerConditionBuilder builder = new IssuerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<IssuerCondition> items) {
    for (IssuerCondition item : items) {IssuerConditionBuilder builder = new IssuerConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<IssuerConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<IssuerConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      IssuerConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<IssuerCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<IssuerCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public IssuerCondition buildCondition(Integer index) {
    return this.conditions.get(index).build();
  }
  public IssuerCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public IssuerCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public IssuerCondition buildMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
    for (IssuerConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
    for (IssuerConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<IssuerCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new ArrayList(); for (IssuerCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.certmanager.api.model.v1alpha3.IssuerCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (IssuerCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public IssuerStatusFluent.ConditionsNested<A> addNewCondition() {
    return new IssuerStatusFluentImpl.ConditionsNestedImpl();
  }
  public IssuerStatusFluent.ConditionsNested<A> addNewConditionLike(IssuerCondition item) {
    return new IssuerStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public IssuerStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,IssuerCondition item) {
    return new IssuerStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public IssuerStatusFluent.ConditionsNested<A> editCondition(Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IssuerStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public IssuerStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public IssuerStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<IssuerConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IssuerStatusFluentImpl that = (IssuerStatusFluentImpl) o;
    if (acme != null ? !acme.equals(that.acme) :that.acme != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(acme,  conditions,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (acme != null) { sb.append("acme:"); sb.append(acme + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions); }
    sb.append("}");
    return sb.toString();
  }
  class AcmeNestedImpl<N> extends ACMEIssuerStatusFluentImpl<IssuerStatusFluent.AcmeNested<N>> implements IssuerStatusFluent.AcmeNested<N>,Nested<N>{
    AcmeNestedImpl(ACMEIssuerStatus item) {
      this.builder = new ACMEIssuerStatusBuilder(this, item);
    }
    AcmeNestedImpl() {
      this.builder = new ACMEIssuerStatusBuilder(this);
    }
    ACMEIssuerStatusBuilder builder;
    public N and() {
      return (N) IssuerStatusFluentImpl.this.withAcme(builder.build());
    }
    public N endAcme() {
      return and();
    }
    
  }
  class ConditionsNestedImpl<N> extends IssuerConditionFluentImpl<IssuerStatusFluent.ConditionsNested<N>> implements IssuerStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(Integer index,IssuerCondition item) {
      this.index = index;
      this.builder = new IssuerConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new IssuerConditionBuilder(this);
    }
    IssuerConditionBuilder builder;
    Integer index;
    public N and() {
      return (N) IssuerStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}