package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OrderStatusFluentImpl<A extends OrderStatusFluent<A>> extends BaseFluent<A> implements OrderStatusFluent<A>{
  public OrderStatusFluentImpl() {
  }
  public OrderStatusFluentImpl(OrderStatus instance) {
    this.withAuthorizations(instance.getAuthorizations()); 
    this.withCertificate(instance.getCertificate()); 
    this.withFailureTime(instance.getFailureTime()); 
    this.withFinalizeURL(instance.getFinalizeURL()); 
    this.withReason(instance.getReason()); 
    this.withState(instance.getState()); 
    this.withUrl(instance.getUrl()); 
  }
  private ArrayList<ACMEAuthorizationBuilder> authorizations = new ArrayList<ACMEAuthorizationBuilder>();
  private String certificate;
  private String failureTime;
  private String finalizeURL;
  private String reason;
  private String state;
  private String url;
  public A addToAuthorizations(Integer index,ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(index >= 0 ? index : _visitables.get("authorizations").size(), builder);this.authorizations.add(index >= 0 ? index : authorizations.size(), builder); return (A)this;
  }
  public A setToAuthorizations(Integer index,ACMEAuthorization item) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);
    if (index < 0 || index >= _visitables.get("authorizations").size()) { _visitables.get("authorizations").add(builder); } else { _visitables.get("authorizations").set(index, builder);}
    if (index < 0 || index >= authorizations.size()) { authorizations.add(builder); } else { authorizations.set(index, builder);}
     return (A)this;
  }
  public A addToAuthorizations(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization... items) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  public A addAllToAuthorizations(Collection<ACMEAuthorization> items) {
    if (this.authorizations == null) {this.authorizations = new ArrayList<ACMEAuthorizationBuilder>();}
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").add(builder);this.authorizations.add(builder);} return (A)this;
  }
  public A removeFromAuthorizations(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization... items) {
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder);if (this.authorizations != null) {this.authorizations.remove(builder);}} return (A)this;
  }
  public A removeAllFromAuthorizations(Collection<ACMEAuthorization> items) {
    for (ACMEAuthorization item : items) {ACMEAuthorizationBuilder builder = new ACMEAuthorizationBuilder(item);_visitables.get("authorizations").remove(builder);if (this.authorizations != null) {this.authorizations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAuthorizations(Predicate<ACMEAuthorizationBuilder> predicate) {
    if (authorizations == null) return (A) this;
    final Iterator<ACMEAuthorizationBuilder> each = authorizations.iterator();
    final List visitables = _visitables.get("authorizations");
    while (each.hasNext()) {
      ACMEAuthorizationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAuthorizations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ACMEAuthorization> getAuthorizations() {
    return authorizations != null ? build(authorizations) : null;
  }
  public List<ACMEAuthorization> buildAuthorizations() {
    return authorizations != null ? build(authorizations) : null;
  }
  public ACMEAuthorization buildAuthorization(Integer index) {
    return this.authorizations.get(index).build();
  }
  public ACMEAuthorization buildFirstAuthorization() {
    return this.authorizations.get(0).build();
  }
  public ACMEAuthorization buildLastAuthorization() {
    return this.authorizations.get(authorizations.size() - 1).build();
  }
  public ACMEAuthorization buildMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
    for (ACMEAuthorizationBuilder item: authorizations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
    for (ACMEAuthorizationBuilder item: authorizations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAuthorizations(List<ACMEAuthorization> authorizations) {
    if (this.authorizations != null) { _visitables.get("authorizations").removeAll(this.authorizations);}
    if (authorizations != null) {this.authorizations = new ArrayList(); for (ACMEAuthorization item : authorizations){this.addToAuthorizations(item);}} else { this.authorizations = null;} return (A) this;
  }
  public A withAuthorizations(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization... authorizations) {
    if (this.authorizations != null) {this.authorizations.clear();}
    if (authorizations != null) {for (ACMEAuthorization item :authorizations){ this.addToAuthorizations(item);}} return (A) this;
  }
  public Boolean hasAuthorizations() {
    return authorizations != null && !authorizations.isEmpty();
  }
  public OrderStatusFluent.AuthorizationsNested<A> addNewAuthorization() {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl();
  }
  public OrderStatusFluent.AuthorizationsNested<A> addNewAuthorizationLike(ACMEAuthorization item) {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl(-1, item);
  }
  public OrderStatusFluent.AuthorizationsNested<A> setNewAuthorizationLike(Integer index,ACMEAuthorization item) {
    return new OrderStatusFluentImpl.AuthorizationsNestedImpl(index, item);
  }
  public OrderStatusFluent.AuthorizationsNested<A> editAuthorization(Integer index) {
    if (authorizations.size() <= index) throw new RuntimeException("Can't edit authorizations. Index exceeds size.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public OrderStatusFluent.AuthorizationsNested<A> editFirstAuthorization() {
    if (authorizations.size() == 0) throw new RuntimeException("Can't edit first authorizations. The list is empty.");
    return setNewAuthorizationLike(0, buildAuthorization(0));
  }
  public OrderStatusFluent.AuthorizationsNested<A> editLastAuthorization() {
    int index = authorizations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last authorizations. The list is empty.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public OrderStatusFluent.AuthorizationsNested<A> editMatchingAuthorization(Predicate<ACMEAuthorizationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<authorizations.size();i++) { 
    if (predicate.test(authorizations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching authorizations. No match found.");
    return setNewAuthorizationLike(index, buildAuthorization(index));
  }
  public String getCertificate() {
    return this.certificate;
  }
  public A withCertificate(String certificate) {
    this.certificate=certificate; return (A) this;
  }
  public Boolean hasCertificate() {
    return this.certificate != null;
  }
  public String getFailureTime() {
    return this.failureTime;
  }
  public A withFailureTime(String failureTime) {
    this.failureTime=failureTime; return (A) this;
  }
  public Boolean hasFailureTime() {
    return this.failureTime != null;
  }
  public String getFinalizeURL() {
    return this.finalizeURL;
  }
  public A withFinalizeURL(String finalizeURL) {
    this.finalizeURL=finalizeURL; return (A) this;
  }
  public Boolean hasFinalizeURL() {
    return this.finalizeURL != null;
  }
  public String getReason() {
    return this.reason;
  }
  public A withReason(String reason) {
    this.reason=reason; return (A) this;
  }
  public Boolean hasReason() {
    return this.reason != null;
  }
  public String getState() {
    return this.state;
  }
  public A withState(String state) {
    this.state=state; return (A) this;
  }
  public Boolean hasState() {
    return this.state != null;
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderStatusFluentImpl that = (OrderStatusFluentImpl) o;
    if (authorizations != null ? !authorizations.equals(that.authorizations) :that.authorizations != null) return false;
    if (certificate != null ? !certificate.equals(that.certificate) :that.certificate != null) return false;
    if (failureTime != null ? !failureTime.equals(that.failureTime) :that.failureTime != null) return false;
    if (finalizeURL != null ? !finalizeURL.equals(that.finalizeURL) :that.finalizeURL != null) return false;
    if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
    if (state != null ? !state.equals(that.state) :that.state != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authorizations,  certificate,  failureTime,  finalizeURL,  reason,  state,  url,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authorizations != null && !authorizations.isEmpty()) { sb.append("authorizations:"); sb.append(authorizations + ","); }
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (failureTime != null) { sb.append("failureTime:"); sb.append(failureTime + ","); }
    if (finalizeURL != null) { sb.append("finalizeURL:"); sb.append(finalizeURL + ","); }
    if (reason != null) { sb.append("reason:"); sb.append(reason + ","); }
    if (state != null) { sb.append("state:"); sb.append(state + ","); }
    if (url != null) { sb.append("url:"); sb.append(url); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationsNestedImpl<N> extends ACMEAuthorizationFluentImpl<OrderStatusFluent.AuthorizationsNested<N>> implements OrderStatusFluent.AuthorizationsNested<N>,Nested<N>{
    AuthorizationsNestedImpl(Integer index,ACMEAuthorization item) {
      this.index = index;
      this.builder = new ACMEAuthorizationBuilder(this, item);
    }
    AuthorizationsNestedImpl() {
      this.index = -1;
      this.builder = new ACMEAuthorizationBuilder(this);
    }
    ACMEAuthorizationBuilder builder;
    Integer index;
    public N and() {
      return (N) OrderStatusFluentImpl.this.setToAuthorizations(index,builder.build());
    }
    public N endAuthorization() {
      return and();
    }
    
  }
  
}