package io.fabric8.certmanager.api.model.acme.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.Duration;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OrderSpecFluentImpl<A extends OrderSpecFluent<A>> extends BaseFluent<A> implements OrderSpecFluent<A>{
  public OrderSpecFluentImpl() {
  }
  public OrderSpecFluentImpl(OrderSpec instance) {
    this.withCommonName(instance.getCommonName()); 
    this.withCsr(instance.getCsr()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIssuerRef(instance.getIssuerRef()); 
  }
  private String commonName;
  private String csr;
  private List<String> dnsNames = new ArrayList<String>();
  private Duration duration;
  private List<String> ipAddresses = new ArrayList<String>();
  private ObjectReferenceBuilder issuerRef;
  public String getCommonName() {
    return this.commonName;
  }
  public A withCommonName(String commonName) {
    this.commonName=commonName; return (A) this;
  }
  public Boolean hasCommonName() {
    return this.commonName != null;
  }
  public String getCsr() {
    return this.csr;
  }
  public A withCsr(String csr) {
    this.csr=csr; return (A) this;
  }
  public Boolean hasCsr() {
    return this.csr != null;
  }
  public A addToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(Integer index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear();}
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public Boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public Duration getDuration() {
    return this.duration;
  }
  public A withDuration(Duration duration) {
    this.duration=duration; return (A) this;
  }
  public Boolean hasDuration() {
    return this.duration != null;
  }
  public A addToIpAddresses(Integer index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.add(index, item);
    return (A)this;
  }
  public A setToIpAddresses(Integer index,String item) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    this.ipAddresses.set(index, item); return (A)this;
  }
  public A addToIpAddresses(java.lang.String... items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A addAllToIpAddresses(Collection<String> items) {
    if (this.ipAddresses == null) {this.ipAddresses = new ArrayList<String>();}
    for (String item : items) {this.ipAddresses.add(item);} return (A)this;
  }
  public A removeFromIpAddresses(java.lang.String... items) {
    for (String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public A removeAllFromIpAddresses(Collection<String> items) {
    for (String item : items) {if (this.ipAddresses!= null){ this.ipAddresses.remove(item);}} return (A)this;
  }
  public List<String> getIpAddresses() {
    return this.ipAddresses;
  }
  public String getIpAddress(Integer index) {
    return this.ipAddresses.get(index);
  }
  public String getFirstIpAddress() {
    return this.ipAddresses.get(0);
  }
  public String getLastIpAddress() {
    return this.ipAddresses.get(ipAddresses.size() - 1);
  }
  public String getMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingIpAddress(Predicate<String> predicate) {
    for (String item: ipAddresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withIpAddresses(List<String> ipAddresses) {
    if (ipAddresses != null) {this.ipAddresses = new ArrayList(); for (String item : ipAddresses){this.addToIpAddresses(item);}} else { this.ipAddresses = null;} return (A) this;
  }
  public A withIpAddresses(java.lang.String... ipAddresses) {
    if (this.ipAddresses != null) {this.ipAddresses.clear();}
    if (ipAddresses != null) {for (String item :ipAddresses){ this.addToIpAddresses(item);}} return (A) this;
  }
  public Boolean hasIpAddresses() {
    return ipAddresses != null && !ipAddresses.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildIssuerRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectReference getIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public ObjectReference buildIssuerRef() {
    return this.issuerRef!=null ?this.issuerRef.build():null;
  }
  public A withIssuerRef(ObjectReference issuerRef) {
    _visitables.get("issuerRef").remove(this.issuerRef);
    if (issuerRef!=null){ this.issuerRef= new ObjectReferenceBuilder(issuerRef); _visitables.get("issuerRef").add(this.issuerRef);} else { this.issuerRef = null; _visitables.get("issuerRef").remove(this.issuerRef); } return (A) this;
  }
  public Boolean hasIssuerRef() {
    return this.issuerRef != null;
  }
  public A withNewIssuerRef(String group,String kind,String name) {
    return (A)withIssuerRef(new ObjectReference(group, kind, name));
  }
  public OrderSpecFluent.IssuerRefNested<A> withNewIssuerRef() {
    return new OrderSpecFluentImpl.IssuerRefNestedImpl();
  }
  public OrderSpecFluent.IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
    return new OrderSpecFluentImpl.IssuerRefNestedImpl(item);
  }
  public OrderSpecFluent.IssuerRefNested<A> editIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef());
  }
  public OrderSpecFluent.IssuerRefNested<A> editOrNewIssuerRef() {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): new ObjectReferenceBuilder().build());
  }
  public OrderSpecFluent.IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
    return withNewIssuerRefLike(getIssuerRef() != null ? getIssuerRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OrderSpecFluentImpl that = (OrderSpecFluentImpl) o;
    if (commonName != null ? !commonName.equals(that.commonName) :that.commonName != null) return false;
    if (csr != null ? !csr.equals(that.csr) :that.csr != null) return false;
    if (dnsNames != null ? !dnsNames.equals(that.dnsNames) :that.dnsNames != null) return false;
    if (duration != null ? !duration.equals(that.duration) :that.duration != null) return false;
    if (ipAddresses != null ? !ipAddresses.equals(that.ipAddresses) :that.ipAddresses != null) return false;
    if (issuerRef != null ? !issuerRef.equals(that.issuerRef) :that.issuerRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(commonName,  csr,  dnsNames,  duration,  ipAddresses,  issuerRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (commonName != null) { sb.append("commonName:"); sb.append(commonName + ","); }
    if (csr != null) { sb.append("csr:"); sb.append(csr + ","); }
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (duration != null) { sb.append("duration:"); sb.append(duration + ","); }
    if (ipAddresses != null && !ipAddresses.isEmpty()) { sb.append("ipAddresses:"); sb.append(ipAddresses + ","); }
    if (issuerRef != null) { sb.append("issuerRef:"); sb.append(issuerRef); }
    sb.append("}");
    return sb.toString();
  }
  class IssuerRefNestedImpl<N> extends ObjectReferenceFluentImpl<OrderSpecFluent.IssuerRefNested<N>> implements OrderSpecFluent.IssuerRefNested<N>,Nested<N>{
    IssuerRefNestedImpl(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    IssuerRefNestedImpl() {
      this.builder = new ObjectReferenceBuilder(this);
    }
    ObjectReferenceBuilder builder;
    public N and() {
      return (N) OrderSpecFluentImpl.this.withIssuerRef(builder.build());
    }
    public N endIssuerRef() {
      return and();
    }
    
  }
  
}