package io.fabric8.certmanager.api.model.acme.v1alpha3;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateDNSNameSelectorFluentImpl<A extends CertificateDNSNameSelectorFluent<A>> extends BaseFluent<A> implements CertificateDNSNameSelectorFluent<A>{
  public CertificateDNSNameSelectorFluentImpl() {
  }
  public CertificateDNSNameSelectorFluentImpl(CertificateDNSNameSelector instance) {
    this.withDnsNames(instance.getDnsNames()); 
    this.withDnsZones(instance.getDnsZones()); 
    this.withMatchLabels(instance.getMatchLabels()); 
  }
  private List<String> dnsNames = new ArrayList<String>();
  private List<String> dnsZones = new ArrayList<String>();
  private Map<String,String> matchLabels;
  public A addToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.add(index, item);
    return (A)this;
  }
  public A setToDnsNames(Integer index,String item) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    this.dnsNames.set(index, item); return (A)this;
  }
  public A addToDnsNames(java.lang.String... items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A addAllToDnsNames(Collection<String> items) {
    if (this.dnsNames == null) {this.dnsNames = new ArrayList<String>();}
    for (String item : items) {this.dnsNames.add(item);} return (A)this;
  }
  public A removeFromDnsNames(java.lang.String... items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public A removeAllFromDnsNames(Collection<String> items) {
    for (String item : items) {if (this.dnsNames!= null){ this.dnsNames.remove(item);}} return (A)this;
  }
  public List<String> getDnsNames() {
    return this.dnsNames;
  }
  public String getDnsName(Integer index) {
    return this.dnsNames.get(index);
  }
  public String getFirstDnsName() {
    return this.dnsNames.get(0);
  }
  public String getLastDnsName() {
    return this.dnsNames.get(dnsNames.size() - 1);
  }
  public String getMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDnsName(Predicate<String> predicate) {
    for (String item: dnsNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsNames(List<String> dnsNames) {
    if (dnsNames != null) {this.dnsNames = new ArrayList(); for (String item : dnsNames){this.addToDnsNames(item);}} else { this.dnsNames = null;} return (A) this;
  }
  public A withDnsNames(java.lang.String... dnsNames) {
    if (this.dnsNames != null) {this.dnsNames.clear();}
    if (dnsNames != null) {for (String item :dnsNames){ this.addToDnsNames(item);}} return (A) this;
  }
  public Boolean hasDnsNames() {
    return dnsNames != null && !dnsNames.isEmpty();
  }
  public A addToDnsZones(Integer index,String item) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    this.dnsZones.add(index, item);
    return (A)this;
  }
  public A setToDnsZones(Integer index,String item) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    this.dnsZones.set(index, item); return (A)this;
  }
  public A addToDnsZones(java.lang.String... items) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    for (String item : items) {this.dnsZones.add(item);} return (A)this;
  }
  public A addAllToDnsZones(Collection<String> items) {
    if (this.dnsZones == null) {this.dnsZones = new ArrayList<String>();}
    for (String item : items) {this.dnsZones.add(item);} return (A)this;
  }
  public A removeFromDnsZones(java.lang.String... items) {
    for (String item : items) {if (this.dnsZones!= null){ this.dnsZones.remove(item);}} return (A)this;
  }
  public A removeAllFromDnsZones(Collection<String> items) {
    for (String item : items) {if (this.dnsZones!= null){ this.dnsZones.remove(item);}} return (A)this;
  }
  public List<String> getDnsZones() {
    return this.dnsZones;
  }
  public String getDnsZone(Integer index) {
    return this.dnsZones.get(index);
  }
  public String getFirstDnsZone() {
    return this.dnsZones.get(0);
  }
  public String getLastDnsZone() {
    return this.dnsZones.get(dnsZones.size() - 1);
  }
  public String getMatchingDnsZone(Predicate<String> predicate) {
    for (String item: dnsZones) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDnsZone(Predicate<String> predicate) {
    for (String item: dnsZones) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDnsZones(List<String> dnsZones) {
    if (dnsZones != null) {this.dnsZones = new ArrayList(); for (String item : dnsZones){this.addToDnsZones(item);}} else { this.dnsZones = null;} return (A) this;
  }
  public A withDnsZones(java.lang.String... dnsZones) {
    if (this.dnsZones != null) {this.dnsZones.clear();}
    if (dnsZones != null) {for (String item :dnsZones){ this.addToDnsZones(item);}} return (A) this;
  }
  public Boolean hasDnsZones() {
    return dnsZones != null && !dnsZones.isEmpty();
  }
  public A addToMatchLabels(String key,String value) {
    if(this.matchLabels == null && key != null && value != null) { this.matchLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.matchLabels.put(key, value);} return (A)this;
  }
  public A addToMatchLabels(Map<String,String> map) {
    if(this.matchLabels == null && map != null) { this.matchLabels = new LinkedHashMap(); }
    if(map != null) { this.matchLabels.putAll(map);} return (A)this;
  }
  public A removeFromMatchLabels(String key) {
    if(this.matchLabels == null) { return (A) this; }
    if(key != null && this.matchLabels != null) {this.matchLabels.remove(key);} return (A)this;
  }
  public A removeFromMatchLabels(Map<String,String> map) {
    if(this.matchLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.matchLabels != null){this.matchLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getMatchLabels() {
    return this.matchLabels;
  }
  public <K,V>A withMatchLabels(Map<String,String> matchLabels) {
    if (matchLabels == null) { this.matchLabels =  null;} else {this.matchLabels = new LinkedHashMap(matchLabels);} return (A) this;
  }
  public Boolean hasMatchLabels() {
    return this.matchLabels != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CertificateDNSNameSelectorFluentImpl that = (CertificateDNSNameSelectorFluentImpl) o;
    if (dnsNames != null ? !dnsNames.equals(that.dnsNames) :that.dnsNames != null) return false;
    if (dnsZones != null ? !dnsZones.equals(that.dnsZones) :that.dnsZones != null) return false;
    if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(dnsNames,  dnsZones,  matchLabels,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (dnsNames != null && !dnsNames.isEmpty()) { sb.append("dnsNames:"); sb.append(dnsNames + ","); }
    if (dnsZones != null && !dnsZones.isEmpty()) { sb.append("dnsZones:"); sb.append(dnsZones + ","); }
    if (matchLabels != null && !matchLabels.isEmpty()) { sb.append("matchLabels:"); sb.append(matchLabels); }
    sb.append("}");
    return sb.toString();
  }
  
}