package io.fabric8.certmanager.api.model.acme.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerDNS01ProviderCloudDNSFluentImpl<A extends ACMEIssuerDNS01ProviderCloudDNSFluent<A>> extends BaseFluent<A> implements ACMEIssuerDNS01ProviderCloudDNSFluent<A>{
  public ACMEIssuerDNS01ProviderCloudDNSFluentImpl() {
  }
  public ACMEIssuerDNS01ProviderCloudDNSFluentImpl(ACMEIssuerDNS01ProviderCloudDNS instance) {
    this.withHostedZoneName(instance.getHostedZoneName()); 
    this.withProject(instance.getProject()); 
    this.withServiceAccountSecretRef(instance.getServiceAccountSecretRef()); 
  }
  private String hostedZoneName;
  private String project;
  private SecretKeySelectorBuilder serviceAccountSecretRef;
  public String getHostedZoneName() {
    return this.hostedZoneName;
  }
  public A withHostedZoneName(String hostedZoneName) {
    this.hostedZoneName=hostedZoneName; return (A) this;
  }
  public Boolean hasHostedZoneName() {
    return this.hostedZoneName != null;
  }
  public String getProject() {
    return this.project;
  }
  public A withProject(String project) {
    this.project=project; return (A) this;
  }
  public Boolean hasProject() {
    return this.project != null;
  }
  
  /**
   * This method has been deprecated, please use method buildServiceAccountSecretRef instead.
   * @return The buildable object.
   */
  @Deprecated
  public SecretKeySelector getServiceAccountSecretRef() {
    return this.serviceAccountSecretRef!=null ?this.serviceAccountSecretRef.build():null;
  }
  public SecretKeySelector buildServiceAccountSecretRef() {
    return this.serviceAccountSecretRef!=null ?this.serviceAccountSecretRef.build():null;
  }
  public A withServiceAccountSecretRef(SecretKeySelector serviceAccountSecretRef) {
    _visitables.get("serviceAccountSecretRef").remove(this.serviceAccountSecretRef);
    if (serviceAccountSecretRef!=null){ this.serviceAccountSecretRef= new SecretKeySelectorBuilder(serviceAccountSecretRef); _visitables.get("serviceAccountSecretRef").add(this.serviceAccountSecretRef);} else { this.serviceAccountSecretRef = null; _visitables.get("serviceAccountSecretRef").remove(this.serviceAccountSecretRef); } return (A) this;
  }
  public Boolean hasServiceAccountSecretRef() {
    return this.serviceAccountSecretRef != null;
  }
  public A withNewServiceAccountSecretRef(String key,String name) {
    return (A)withServiceAccountSecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> withNewServiceAccountSecretRef() {
    return new ACMEIssuerDNS01ProviderCloudDNSFluentImpl.ServiceAccountSecretRefNestedImpl();
  }
  public ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> withNewServiceAccountSecretRefLike(SecretKeySelector item) {
    return new ACMEIssuerDNS01ProviderCloudDNSFluentImpl.ServiceAccountSecretRefNestedImpl(item);
  }
  public ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> editServiceAccountSecretRef() {
    return withNewServiceAccountSecretRefLike(getServiceAccountSecretRef());
  }
  public ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> editOrNewServiceAccountSecretRef() {
    return withNewServiceAccountSecretRefLike(getServiceAccountSecretRef() != null ? getServiceAccountSecretRef(): new SecretKeySelectorBuilder().build());
  }
  public ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> editOrNewServiceAccountSecretRefLike(SecretKeySelector item) {
    return withNewServiceAccountSecretRefLike(getServiceAccountSecretRef() != null ? getServiceAccountSecretRef(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEIssuerDNS01ProviderCloudDNSFluentImpl that = (ACMEIssuerDNS01ProviderCloudDNSFluentImpl) o;
    if (hostedZoneName != null ? !hostedZoneName.equals(that.hostedZoneName) :that.hostedZoneName != null) return false;
    if (project != null ? !project.equals(that.project) :that.project != null) return false;
    if (serviceAccountSecretRef != null ? !serviceAccountSecretRef.equals(that.serviceAccountSecretRef) :that.serviceAccountSecretRef != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hostedZoneName,  project,  serviceAccountSecretRef,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hostedZoneName != null) { sb.append("hostedZoneName:"); sb.append(hostedZoneName + ","); }
    if (project != null) { sb.append("project:"); sb.append(project + ","); }
    if (serviceAccountSecretRef != null) { sb.append("serviceAccountSecretRef:"); sb.append(serviceAccountSecretRef); }
    sb.append("}");
    return sb.toString();
  }
  class ServiceAccountSecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<N>> implements ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<N>,Nested<N>{
    ServiceAccountSecretRefNestedImpl(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    ServiceAccountSecretRefNestedImpl() {
      this.builder = new SecretKeySelectorBuilder(this);
    }
    SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerDNS01ProviderCloudDNSFluentImpl.this.withServiceAccountSecretRef(builder.build());
    }
    public N endServiceAccountSecretRef() {
      return and();
    }
    
  }
  
}