package io.fabric8.certmanager.api.model.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class VenafiCloudFluent<A extends VenafiCloudFluent<A>> extends BaseFluent<A>{
  public VenafiCloudFluent() {
  }
  
  public VenafiCloudFluent(VenafiCloud instance) {
    this.copyInstance(instance);
  }
  private SecretKeySelectorBuilder apiTokenSecretRef;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(VenafiCloud instance) {
    instance = (instance != null ? instance : new VenafiCloud());
    if (instance != null) {
          this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
          this.withUrl(instance.getUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretKeySelector buildApiTokenSecretRef() {
    return this.apiTokenSecretRef != null ? this.apiTokenSecretRef.build() : null;
  }
  
  public A withApiTokenSecretRef(SecretKeySelector apiTokenSecretRef) {
    this._visitables.remove("apiTokenSecretRef");
    if (apiTokenSecretRef != null) {
        this.apiTokenSecretRef = new SecretKeySelectorBuilder(apiTokenSecretRef);
        this._visitables.get("apiTokenSecretRef").add(this.apiTokenSecretRef);
    } else {
        this.apiTokenSecretRef = null;
        this._visitables.get("apiTokenSecretRef").remove(this.apiTokenSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasApiTokenSecretRef() {
    return this.apiTokenSecretRef != null;
  }
  
  public A withNewApiTokenSecretRef(String key,String name) {
    return (A)withApiTokenSecretRef(new SecretKeySelector(key, name));
  }
  
  public ApiTokenSecretRefNested<A> withNewApiTokenSecretRef() {
    return new ApiTokenSecretRefNested(null);
  }
  
  public ApiTokenSecretRefNested<A> withNewApiTokenSecretRefLike(SecretKeySelector item) {
    return new ApiTokenSecretRefNested(item);
  }
  
  public ApiTokenSecretRefNested<A> editApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(null));
  }
  
  public ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRefLike(SecretKeySelector item) {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(item));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    VenafiCloudFluent that = (VenafiCloudFluent) o;
    if (!java.util.Objects.equals(apiTokenSecretRef, that.apiTokenSecretRef)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiTokenSecretRef,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiTokenSecretRef != null) { sb.append("apiTokenSecretRef:"); sb.append(apiTokenSecretRef + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ApiTokenSecretRefNested<N> extends SecretKeySelectorFluent<ApiTokenSecretRefNested<N>> implements Nested<N>{
    ApiTokenSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) VenafiCloudFluent.this.withApiTokenSecretRef(builder.build());
    }
    
    public N endApiTokenSecretRef() {
      return and();
    }
    
  
  }

}