package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertificateRequestSpecBuilder extends CertificateRequestSpecFluent<CertificateRequestSpecBuilder> implements VisitableBuilder<CertificateRequestSpec,CertificateRequestSpecBuilder>{
  public CertificateRequestSpecBuilder() {
    this(new CertificateRequestSpec());
  }
  
  public CertificateRequestSpecBuilder(CertificateRequestSpecFluent<?> fluent) {
    this(fluent, new CertificateRequestSpec());
  }
  
  public CertificateRequestSpecBuilder(CertificateRequestSpecFluent<?> fluent,CertificateRequestSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertificateRequestSpecBuilder(CertificateRequestSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertificateRequestSpecFluent<?> fluent;
  
  public CertificateRequestSpec build() {
    CertificateRequestSpec buildable = new CertificateRequestSpec(fluent.getCsr(),fluent.getDuration(),fluent.getExtra(),fluent.getGroups(),fluent.getIsCA(),fluent.buildIssuerRef(),fluent.getUid(),fluent.getUsages(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}