/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAppRole;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleFluent;
import io.fabric8.certmanager.api.model.v1alpha3.VaultAuth;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuth;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuthBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.VaultKubernetesAuthFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class VaultAuthFluent<A extends VaultAuthFluent<A>>
extends BaseFluent<A> {
    private VaultAppRoleBuilder appRole;
    private VaultKubernetesAuthBuilder kubernetes;
    private SecretKeySelectorBuilder tokenSecretRef;
    private Map<String, Object> additionalProperties;

    public VaultAuthFluent() {
    }

    public VaultAuthFluent(VaultAuth instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VaultAuth instance) {
        VaultAuth vaultAuth = instance = instance != null ? instance : new VaultAuth();
        if (instance != null) {
            this.withAppRole(instance.getAppRole());
            this.withKubernetes(instance.getKubernetes());
            this.withTokenSecretRef(instance.getTokenSecretRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public VaultAppRole buildAppRole() {
        return this.appRole != null ? this.appRole.build() : null;
    }

    public A withAppRole(VaultAppRole appRole) {
        this._visitables.remove((Object)"appRole");
        if (appRole != null) {
            this.appRole = new VaultAppRoleBuilder(appRole);
            this._visitables.get((Object)"appRole").add(this.appRole);
        } else {
            this.appRole = null;
            this._visitables.get((Object)"appRole").remove((Object)this.appRole);
        }
        return (A)((Object)this);
    }

    public boolean hasAppRole() {
        return this.appRole != null;
    }

    public AppRoleNested<A> withNewAppRole() {
        return new AppRoleNested(null);
    }

    public AppRoleNested<A> withNewAppRoleLike(VaultAppRole item) {
        return new AppRoleNested(item);
    }

    public AppRoleNested<A> editAppRole() {
        return this.withNewAppRoleLike(Optional.ofNullable(this.buildAppRole()).orElse(null));
    }

    public AppRoleNested<A> editOrNewAppRole() {
        return this.withNewAppRoleLike(Optional.ofNullable(this.buildAppRole()).orElse(new VaultAppRoleBuilder().build()));
    }

    public AppRoleNested<A> editOrNewAppRoleLike(VaultAppRole item) {
        return this.withNewAppRoleLike(Optional.ofNullable(this.buildAppRole()).orElse(item));
    }

    public VaultKubernetesAuth buildKubernetes() {
        return this.kubernetes != null ? this.kubernetes.build() : null;
    }

    public A withKubernetes(VaultKubernetesAuth kubernetes) {
        this._visitables.remove((Object)"kubernetes");
        if (kubernetes != null) {
            this.kubernetes = new VaultKubernetesAuthBuilder(kubernetes);
            this._visitables.get((Object)"kubernetes").add(this.kubernetes);
        } else {
            this.kubernetes = null;
            this._visitables.get((Object)"kubernetes").remove((Object)this.kubernetes);
        }
        return (A)((Object)this);
    }

    public boolean hasKubernetes() {
        return this.kubernetes != null;
    }

    public KubernetesNested<A> withNewKubernetes() {
        return new KubernetesNested(null);
    }

    public KubernetesNested<A> withNewKubernetesLike(VaultKubernetesAuth item) {
        return new KubernetesNested(item);
    }

    public KubernetesNested<A> editKubernetes() {
        return this.withNewKubernetesLike(Optional.ofNullable(this.buildKubernetes()).orElse(null));
    }

    public KubernetesNested<A> editOrNewKubernetes() {
        return this.withNewKubernetesLike(Optional.ofNullable(this.buildKubernetes()).orElse(new VaultKubernetesAuthBuilder().build()));
    }

    public KubernetesNested<A> editOrNewKubernetesLike(VaultKubernetesAuth item) {
        return this.withNewKubernetesLike(Optional.ofNullable(this.buildKubernetes()).orElse(item));
    }

    public SecretKeySelector buildTokenSecretRef() {
        return this.tokenSecretRef != null ? this.tokenSecretRef.build() : null;
    }

    public A withTokenSecretRef(SecretKeySelector tokenSecretRef) {
        this._visitables.remove((Object)"tokenSecretRef");
        if (tokenSecretRef != null) {
            this.tokenSecretRef = new SecretKeySelectorBuilder(tokenSecretRef);
            this._visitables.get((Object)"tokenSecretRef").add(this.tokenSecretRef);
        } else {
            this.tokenSecretRef = null;
            this._visitables.get((Object)"tokenSecretRef").remove((Object)this.tokenSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasTokenSecretRef() {
        return this.tokenSecretRef != null;
    }

    public A withNewTokenSecretRef(String key, String name) {
        return this.withTokenSecretRef(new SecretKeySelector(key, name));
    }

    public TokenSecretRefNested<A> withNewTokenSecretRef() {
        return new TokenSecretRefNested(null);
    }

    public TokenSecretRefNested<A> withNewTokenSecretRefLike(SecretKeySelector item) {
        return new TokenSecretRefNested(item);
    }

    public TokenSecretRefNested<A> editTokenSecretRef() {
        return this.withNewTokenSecretRefLike(Optional.ofNullable(this.buildTokenSecretRef()).orElse(null));
    }

    public TokenSecretRefNested<A> editOrNewTokenSecretRef() {
        return this.withNewTokenSecretRefLike(Optional.ofNullable(this.buildTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public TokenSecretRefNested<A> editOrNewTokenSecretRefLike(SecretKeySelector item) {
        return this.withNewTokenSecretRefLike(Optional.ofNullable(this.buildTokenSecretRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VaultAuthFluent that = (VaultAuthFluent)((Object)o);
        if (!Objects.equals((Object)this.appRole, (Object)that.appRole)) {
            return false;
        }
        if (!Objects.equals((Object)this.kubernetes, (Object)that.kubernetes)) {
            return false;
        }
        if (!Objects.equals((Object)this.tokenSecretRef, (Object)that.tokenSecretRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appRole, this.kubernetes, this.tokenSecretRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appRole != null) {
            sb.append("appRole:");
            sb.append((Object)((Object)this.appRole) + ",");
        }
        if (this.kubernetes != null) {
            sb.append("kubernetes:");
            sb.append((Object)((Object)this.kubernetes) + ",");
        }
        if (this.tokenSecretRef != null) {
            sb.append("tokenSecretRef:");
            sb.append((Object)((Object)this.tokenSecretRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TokenSecretRefNested<N>
    extends SecretKeySelectorFluent<TokenSecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        TokenSecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)VaultAuthFluent.this.withTokenSecretRef(this.builder.build());
        }

        public N endTokenSecretRef() {
            return this.and();
        }
    }

    public class KubernetesNested<N>
    extends VaultKubernetesAuthFluent<KubernetesNested<N>>
    implements Nested<N> {
        VaultKubernetesAuthBuilder builder;

        KubernetesNested(VaultKubernetesAuth item) {
            this.builder = new VaultKubernetesAuthBuilder(this, item);
        }

        public N and() {
            return (N)VaultAuthFluent.this.withKubernetes(this.builder.build());
        }

        public N endKubernetes() {
            return this.and();
        }
    }

    public class AppRoleNested<N>
    extends VaultAppRoleFluent<AppRoleNested<N>>
    implements Nested<N> {
        VaultAppRoleBuilder builder;

        AppRoleNested(VaultAppRole item) {
            this.builder = new VaultAppRoleBuilder(this, item);
        }

        public N and() {
            return (N)VaultAuthFluent.this.withAppRole(this.builder.build());
        }

        public N endAppRole() {
            return this.and();
        }
    }
}

