/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.certmanager.api.model.v1alpha3.PKCS12Keystore;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PKCS12KeystoreFluent<A extends PKCS12KeystoreFluent<A>>
extends BaseFluent<A> {
    private Boolean create;
    private SecretKeySelectorBuilder passwordSecretRef;
    private Map<String, Object> additionalProperties;

    public PKCS12KeystoreFluent() {
    }

    public PKCS12KeystoreFluent(PKCS12Keystore instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PKCS12Keystore instance) {
        PKCS12Keystore pKCS12Keystore = instance = instance != null ? instance : new PKCS12Keystore();
        if (instance != null) {
            this.withCreate(instance.getCreate());
            this.withPasswordSecretRef(instance.getPasswordSecretRef());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getCreate() {
        return this.create;
    }

    public A withCreate(Boolean create) {
        this.create = create;
        return (A)((Object)this);
    }

    public boolean hasCreate() {
        return this.create != null;
    }

    public SecretKeySelector buildPasswordSecretRef() {
        return this.passwordSecretRef != null ? this.passwordSecretRef.build() : null;
    }

    public A withPasswordSecretRef(SecretKeySelector passwordSecretRef) {
        this._visitables.remove((Object)"passwordSecretRef");
        if (passwordSecretRef != null) {
            this.passwordSecretRef = new SecretKeySelectorBuilder(passwordSecretRef);
            this._visitables.get((Object)"passwordSecretRef").add(this.passwordSecretRef);
        } else {
            this.passwordSecretRef = null;
            this._visitables.get((Object)"passwordSecretRef").remove((Object)this.passwordSecretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasPasswordSecretRef() {
        return this.passwordSecretRef != null;
    }

    public A withNewPasswordSecretRef(String key, String name) {
        return this.withPasswordSecretRef(new SecretKeySelector(key, name));
    }

    public PasswordSecretRefNested<A> withNewPasswordSecretRef() {
        return new PasswordSecretRefNested(null);
    }

    public PasswordSecretRefNested<A> withNewPasswordSecretRefLike(SecretKeySelector item) {
        return new PasswordSecretRefNested(item);
    }

    public PasswordSecretRefNested<A> editPasswordSecretRef() {
        return this.withNewPasswordSecretRefLike(Optional.ofNullable(this.buildPasswordSecretRef()).orElse(null));
    }

    public PasswordSecretRefNested<A> editOrNewPasswordSecretRef() {
        return this.withNewPasswordSecretRefLike(Optional.ofNullable(this.buildPasswordSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
    }

    public PasswordSecretRefNested<A> editOrNewPasswordSecretRefLike(SecretKeySelector item) {
        return this.withNewPasswordSecretRefLike(Optional.ofNullable(this.buildPasswordSecretRef()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PKCS12KeystoreFluent that = (PKCS12KeystoreFluent)((Object)o);
        if (!Objects.equals(this.create, that.create)) {
            return false;
        }
        if (!Objects.equals((Object)this.passwordSecretRef, (Object)that.passwordSecretRef)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.create, this.passwordSecretRef, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.create != null) {
            sb.append("create:");
            sb.append(this.create + ",");
        }
        if (this.passwordSecretRef != null) {
            sb.append("passwordSecretRef:");
            sb.append((Object)((Object)this.passwordSecretRef) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withCreate() {
        return this.withCreate(true);
    }

    public class PasswordSecretRefNested<N>
    extends SecretKeySelectorFluent<PasswordSecretRefNested<N>>
    implements Nested<N> {
        SecretKeySelectorBuilder builder;

        PasswordSecretRefNested(SecretKeySelector item) {
            this.builder = new SecretKeySelectorBuilder(this, item);
        }

        public N and() {
            return (N)PKCS12KeystoreFluent.this.withPasswordSecretRef(this.builder.build());
        }

        public N endPasswordSecretRef() {
            return this.and();
        }
    }
}

