/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerBuilder;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent;
import io.fabric8.certmanager.api.model.v1alpha3.CAIssuer;
import io.fabric8.certmanager.api.model.v1alpha3.CAIssuerBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.CAIssuerFluent;
import io.fabric8.certmanager.api.model.v1alpha3.IssuerSpec;
import io.fabric8.certmanager.api.model.v1alpha3.SelfSignedIssuer;
import io.fabric8.certmanager.api.model.v1alpha3.SelfSignedIssuerBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.SelfSignedIssuerFluent;
import io.fabric8.certmanager.api.model.v1alpha3.VaultIssuer;
import io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent;
import io.fabric8.certmanager.api.model.v1alpha3.VenafiIssuer;
import io.fabric8.certmanager.api.model.v1alpha3.VenafiIssuerBuilder;
import io.fabric8.certmanager.api.model.v1alpha3.VenafiIssuerFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IssuerSpecFluent<A extends IssuerSpecFluent<A>>
extends BaseFluent<A> {
    private ACMEIssuerBuilder acme;
    private CAIssuerBuilder ca;
    private SelfSignedIssuerBuilder selfSigned;
    private VaultIssuerBuilder vault;
    private VenafiIssuerBuilder venafi;
    private Map<String, Object> additionalProperties;

    public IssuerSpecFluent() {
    }

    public IssuerSpecFluent(IssuerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(IssuerSpec instance) {
        IssuerSpec issuerSpec = instance = instance != null ? instance : new IssuerSpec();
        if (instance != null) {
            this.withAcme(instance.getAcme());
            this.withCa(instance.getCa());
            this.withSelfSigned(instance.getSelfSigned());
            this.withVault(instance.getVault());
            this.withVenafi(instance.getVenafi());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ACMEIssuer buildAcme() {
        return this.acme != null ? this.acme.build() : null;
    }

    public A withAcme(ACMEIssuer acme) {
        this._visitables.remove((Object)"acme");
        if (acme != null) {
            this.acme = new ACMEIssuerBuilder(acme);
            this._visitables.get((Object)"acme").add(this.acme);
        } else {
            this.acme = null;
            this._visitables.get((Object)"acme").remove((Object)this.acme);
        }
        return (A)((Object)this);
    }

    public boolean hasAcme() {
        return this.acme != null;
    }

    public AcmeNested<A> withNewAcme() {
        return new AcmeNested(null);
    }

    public AcmeNested<A> withNewAcmeLike(ACMEIssuer item) {
        return new AcmeNested(item);
    }

    public AcmeNested<A> editAcme() {
        return this.withNewAcmeLike(Optional.ofNullable(this.buildAcme()).orElse(null));
    }

    public AcmeNested<A> editOrNewAcme() {
        return this.withNewAcmeLike(Optional.ofNullable(this.buildAcme()).orElse(new ACMEIssuerBuilder().build()));
    }

    public AcmeNested<A> editOrNewAcmeLike(ACMEIssuer item) {
        return this.withNewAcmeLike(Optional.ofNullable(this.buildAcme()).orElse(item));
    }

    public CAIssuer buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    public A withCa(CAIssuer ca) {
        this._visitables.remove((Object)"ca");
        if (ca != null) {
            this.ca = new CAIssuerBuilder(ca);
            this._visitables.get((Object)"ca").add(this.ca);
        } else {
            this.ca = null;
            this._visitables.get((Object)"ca").remove((Object)this.ca);
        }
        return (A)((Object)this);
    }

    public boolean hasCa() {
        return this.ca != null;
    }

    public CaNested<A> withNewCa() {
        return new CaNested(null);
    }

    public CaNested<A> withNewCaLike(CAIssuer item) {
        return new CaNested(item);
    }

    public CaNested<A> editCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(null));
    }

    public CaNested<A> editOrNewCa() {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(new CAIssuerBuilder().build()));
    }

    public CaNested<A> editOrNewCaLike(CAIssuer item) {
        return this.withNewCaLike(Optional.ofNullable(this.buildCa()).orElse(item));
    }

    public SelfSignedIssuer buildSelfSigned() {
        return this.selfSigned != null ? this.selfSigned.build() : null;
    }

    public A withSelfSigned(SelfSignedIssuer selfSigned) {
        this._visitables.remove((Object)"selfSigned");
        if (selfSigned != null) {
            this.selfSigned = new SelfSignedIssuerBuilder(selfSigned);
            this._visitables.get((Object)"selfSigned").add(this.selfSigned);
        } else {
            this.selfSigned = null;
            this._visitables.get((Object)"selfSigned").remove((Object)this.selfSigned);
        }
        return (A)((Object)this);
    }

    public boolean hasSelfSigned() {
        return this.selfSigned != null;
    }

    public SelfSignedNested<A> withNewSelfSigned() {
        return new SelfSignedNested(null);
    }

    public SelfSignedNested<A> withNewSelfSignedLike(SelfSignedIssuer item) {
        return new SelfSignedNested(item);
    }

    public SelfSignedNested<A> editSelfSigned() {
        return this.withNewSelfSignedLike(Optional.ofNullable(this.buildSelfSigned()).orElse(null));
    }

    public SelfSignedNested<A> editOrNewSelfSigned() {
        return this.withNewSelfSignedLike(Optional.ofNullable(this.buildSelfSigned()).orElse(new SelfSignedIssuerBuilder().build()));
    }

    public SelfSignedNested<A> editOrNewSelfSignedLike(SelfSignedIssuer item) {
        return this.withNewSelfSignedLike(Optional.ofNullable(this.buildSelfSigned()).orElse(item));
    }

    public VaultIssuer buildVault() {
        return this.vault != null ? this.vault.build() : null;
    }

    public A withVault(VaultIssuer vault) {
        this._visitables.remove((Object)"vault");
        if (vault != null) {
            this.vault = new VaultIssuerBuilder(vault);
            this._visitables.get((Object)"vault").add(this.vault);
        } else {
            this.vault = null;
            this._visitables.get((Object)"vault").remove((Object)this.vault);
        }
        return (A)((Object)this);
    }

    public boolean hasVault() {
        return this.vault != null;
    }

    public VaultNested<A> withNewVault() {
        return new VaultNested(null);
    }

    public VaultNested<A> withNewVaultLike(VaultIssuer item) {
        return new VaultNested(item);
    }

    public VaultNested<A> editVault() {
        return this.withNewVaultLike(Optional.ofNullable(this.buildVault()).orElse(null));
    }

    public VaultNested<A> editOrNewVault() {
        return this.withNewVaultLike(Optional.ofNullable(this.buildVault()).orElse(new VaultIssuerBuilder().build()));
    }

    public VaultNested<A> editOrNewVaultLike(VaultIssuer item) {
        return this.withNewVaultLike(Optional.ofNullable(this.buildVault()).orElse(item));
    }

    public VenafiIssuer buildVenafi() {
        return this.venafi != null ? this.venafi.build() : null;
    }

    public A withVenafi(VenafiIssuer venafi) {
        this._visitables.remove((Object)"venafi");
        if (venafi != null) {
            this.venafi = new VenafiIssuerBuilder(venafi);
            this._visitables.get((Object)"venafi").add(this.venafi);
        } else {
            this.venafi = null;
            this._visitables.get((Object)"venafi").remove((Object)this.venafi);
        }
        return (A)((Object)this);
    }

    public boolean hasVenafi() {
        return this.venafi != null;
    }

    public VenafiNested<A> withNewVenafi() {
        return new VenafiNested(null);
    }

    public VenafiNested<A> withNewVenafiLike(VenafiIssuer item) {
        return new VenafiNested(item);
    }

    public VenafiNested<A> editVenafi() {
        return this.withNewVenafiLike(Optional.ofNullable(this.buildVenafi()).orElse(null));
    }

    public VenafiNested<A> editOrNewVenafi() {
        return this.withNewVenafiLike(Optional.ofNullable(this.buildVenafi()).orElse(new VenafiIssuerBuilder().build()));
    }

    public VenafiNested<A> editOrNewVenafiLike(VenafiIssuer item) {
        return this.withNewVenafiLike(Optional.ofNullable(this.buildVenafi()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IssuerSpecFluent that = (IssuerSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.acme, (Object)that.acme)) {
            return false;
        }
        if (!Objects.equals((Object)this.ca, (Object)that.ca)) {
            return false;
        }
        if (!Objects.equals((Object)this.selfSigned, (Object)that.selfSigned)) {
            return false;
        }
        if (!Objects.equals((Object)this.vault, (Object)that.vault)) {
            return false;
        }
        if (!Objects.equals((Object)this.venafi, (Object)that.venafi)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.acme, this.ca, this.selfSigned, this.vault, this.venafi, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.acme != null) {
            sb.append("acme:");
            sb.append((Object)((Object)this.acme) + ",");
        }
        if (this.ca != null) {
            sb.append("ca:");
            sb.append((Object)((Object)this.ca) + ",");
        }
        if (this.selfSigned != null) {
            sb.append("selfSigned:");
            sb.append((Object)((Object)this.selfSigned) + ",");
        }
        if (this.vault != null) {
            sb.append("vault:");
            sb.append((Object)((Object)this.vault) + ",");
        }
        if (this.venafi != null) {
            sb.append("venafi:");
            sb.append((Object)((Object)this.venafi) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class VenafiNested<N>
    extends VenafiIssuerFluent<VenafiNested<N>>
    implements Nested<N> {
        VenafiIssuerBuilder builder;

        VenafiNested(VenafiIssuer item) {
            this.builder = new VenafiIssuerBuilder(this, item);
        }

        public N and() {
            return (N)IssuerSpecFluent.this.withVenafi(this.builder.build());
        }

        public N endVenafi() {
            return this.and();
        }
    }

    public class VaultNested<N>
    extends VaultIssuerFluent<VaultNested<N>>
    implements Nested<N> {
        VaultIssuerBuilder builder;

        VaultNested(VaultIssuer item) {
            this.builder = new VaultIssuerBuilder(this, item);
        }

        public N and() {
            return (N)IssuerSpecFluent.this.withVault(this.builder.build());
        }

        public N endVault() {
            return this.and();
        }
    }

    public class SelfSignedNested<N>
    extends SelfSignedIssuerFluent<SelfSignedNested<N>>
    implements Nested<N> {
        SelfSignedIssuerBuilder builder;

        SelfSignedNested(SelfSignedIssuer item) {
            this.builder = new SelfSignedIssuerBuilder(this, item);
        }

        public N and() {
            return (N)IssuerSpecFluent.this.withSelfSigned(this.builder.build());
        }

        public N endSelfSigned() {
            return this.and();
        }
    }

    public class CaNested<N>
    extends CAIssuerFluent<CaNested<N>>
    implements Nested<N> {
        CAIssuerBuilder builder;

        CaNested(CAIssuer item) {
            this.builder = new CAIssuerBuilder(this, item);
        }

        public N and() {
            return (N)IssuerSpecFluent.this.withCa(this.builder.build());
        }

        public N endCa() {
            return this.and();
        }
    }

    public class AcmeNested<N>
    extends ACMEIssuerFluent<AcmeNested<N>>
    implements Nested<N> {
        ACMEIssuerBuilder builder;

        AcmeNested(ACMEIssuer item) {
            this.builder = new ACMEIssuerBuilder(this, item);
        }

        public N and() {
            return (N)IssuerSpecFluent.this.withAcme(this.builder.build());
        }

        public N endAcme() {
            return this.and();
        }
    }
}

