/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverFluent;
import io.fabric8.certmanager.api.model.acme.v1alpha3.ChallengeSpec;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ChallengeSpecFluent<A extends ChallengeSpecFluent<A>>
extends BaseFluent<A> {
    private String authzURL;
    private String dnsName;
    private ObjectReferenceBuilder issuerRef;
    private String key;
    private ACMEChallengeSolverBuilder solver;
    private String token;
    private String type;
    private String url;
    private Boolean wildcard;
    private Map<String, Object> additionalProperties;

    public ChallengeSpecFluent() {
    }

    public ChallengeSpecFluent(ChallengeSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ChallengeSpec instance) {
        ChallengeSpec challengeSpec = instance = instance != null ? instance : new ChallengeSpec();
        if (instance != null) {
            this.withAuthzURL(instance.getAuthzURL());
            this.withDnsName(instance.getDnsName());
            this.withIssuerRef(instance.getIssuerRef());
            this.withKey(instance.getKey());
            this.withSolver(instance.getSolver());
            this.withToken(instance.getToken());
            this.withType(instance.getType());
            this.withUrl(instance.getUrl());
            this.withWildcard(instance.getWildcard());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAuthzURL() {
        return this.authzURL;
    }

    public A withAuthzURL(String authzURL) {
        this.authzURL = authzURL;
        return (A)((Object)this);
    }

    public boolean hasAuthzURL() {
        return this.authzURL != null;
    }

    public String getDnsName() {
        return this.dnsName;
    }

    public A withDnsName(String dnsName) {
        this.dnsName = dnsName;
        return (A)((Object)this);
    }

    public boolean hasDnsName() {
        return this.dnsName != null;
    }

    public ObjectReference buildIssuerRef() {
        return this.issuerRef != null ? this.issuerRef.build() : null;
    }

    public A withIssuerRef(ObjectReference issuerRef) {
        this._visitables.remove((Object)"issuerRef");
        if (issuerRef != null) {
            this.issuerRef = new ObjectReferenceBuilder(issuerRef);
            this._visitables.get((Object)"issuerRef").add(this.issuerRef);
        } else {
            this.issuerRef = null;
            this._visitables.get((Object)"issuerRef").remove((Object)this.issuerRef);
        }
        return (A)((Object)this);
    }

    public boolean hasIssuerRef() {
        return this.issuerRef != null;
    }

    public A withNewIssuerRef(String group, String kind, String name) {
        return this.withIssuerRef(new ObjectReference(group, kind, name));
    }

    public IssuerRefNested<A> withNewIssuerRef() {
        return new IssuerRefNested(null);
    }

    public IssuerRefNested<A> withNewIssuerRefLike(ObjectReference item) {
        return new IssuerRefNested(item);
    }

    public IssuerRefNested<A> editIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(null));
    }

    public IssuerRefNested<A> editOrNewIssuerRef() {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(new ObjectReferenceBuilder().build()));
    }

    public IssuerRefNested<A> editOrNewIssuerRefLike(ObjectReference item) {
        return this.withNewIssuerRefLike(Optional.ofNullable(this.buildIssuerRef()).orElse(item));
    }

    public String getKey() {
        return this.key;
    }

    public A withKey(String key) {
        this.key = key;
        return (A)((Object)this);
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public ACMEChallengeSolver buildSolver() {
        return this.solver != null ? this.solver.build() : null;
    }

    public A withSolver(ACMEChallengeSolver solver) {
        this._visitables.remove((Object)"solver");
        if (solver != null) {
            this.solver = new ACMEChallengeSolverBuilder(solver);
            this._visitables.get((Object)"solver").add(this.solver);
        } else {
            this.solver = null;
            this._visitables.get((Object)"solver").remove((Object)this.solver);
        }
        return (A)((Object)this);
    }

    public boolean hasSolver() {
        return this.solver != null;
    }

    public SolverNested<A> withNewSolver() {
        return new SolverNested(null);
    }

    public SolverNested<A> withNewSolverLike(ACMEChallengeSolver item) {
        return new SolverNested(item);
    }

    public SolverNested<A> editSolver() {
        return this.withNewSolverLike(Optional.ofNullable(this.buildSolver()).orElse(null));
    }

    public SolverNested<A> editOrNewSolver() {
        return this.withNewSolverLike(Optional.ofNullable(this.buildSolver()).orElse(new ACMEChallengeSolverBuilder().build()));
    }

    public SolverNested<A> editOrNewSolverLike(ACMEChallengeSolver item) {
        return this.withNewSolverLike(Optional.ofNullable(this.buildSolver()).orElse(item));
    }

    public String getToken() {
        return this.token;
    }

    public A withToken(String token) {
        this.token = token;
        return (A)((Object)this);
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public String getUrl() {
        return this.url;
    }

    public A withUrl(String url) {
        this.url = url;
        return (A)((Object)this);
    }

    public boolean hasUrl() {
        return this.url != null;
    }

    public Boolean getWildcard() {
        return this.wildcard;
    }

    public A withWildcard(Boolean wildcard) {
        this.wildcard = wildcard;
        return (A)((Object)this);
    }

    public boolean hasWildcard() {
        return this.wildcard != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChallengeSpecFluent that = (ChallengeSpecFluent)((Object)o);
        if (!Objects.equals(this.authzURL, that.authzURL)) {
            return false;
        }
        if (!Objects.equals(this.dnsName, that.dnsName)) {
            return false;
        }
        if (!Objects.equals((Object)this.issuerRef, (Object)that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.key, that.key)) {
            return false;
        }
        if (!Objects.equals((Object)this.solver, (Object)that.solver)) {
            return false;
        }
        if (!Objects.equals(this.token, that.token)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.wildcard, that.wildcard)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authzURL, this.dnsName, this.issuerRef, this.key, this.solver, this.token, this.type, this.url, this.wildcard, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.authzURL != null) {
            sb.append("authzURL:");
            sb.append(this.authzURL + ",");
        }
        if (this.dnsName != null) {
            sb.append("dnsName:");
            sb.append(this.dnsName + ",");
        }
        if (this.issuerRef != null) {
            sb.append("issuerRef:");
            sb.append((Object)((Object)this.issuerRef) + ",");
        }
        if (this.key != null) {
            sb.append("key:");
            sb.append(this.key + ",");
        }
        if (this.solver != null) {
            sb.append("solver:");
            sb.append((Object)((Object)this.solver) + ",");
        }
        if (this.token != null) {
            sb.append("token:");
            sb.append(this.token + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.wildcard != null) {
            sb.append("wildcard:");
            sb.append(this.wildcard + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withWildcard() {
        return this.withWildcard(true);
    }

    public class SolverNested<N>
    extends ACMEChallengeSolverFluent<SolverNested<N>>
    implements Nested<N> {
        ACMEChallengeSolverBuilder builder;

        SolverNested(ACMEChallengeSolver item) {
            this.builder = new ACMEChallengeSolverBuilder(this, item);
        }

        public N and() {
            return (N)ChallengeSpecFluent.this.withSolver(this.builder.build());
        }

        public N endSolver() {
            return this.and();
        }
    }

    public class IssuerRefNested<N>
    extends ObjectReferenceFluent<IssuerRefNested<N>>
    implements Nested<N> {
        ObjectReferenceBuilder builder;

        IssuerRefNested(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ChallengeSpecFluent.this.withIssuerRef(this.builder.build());
        }

        public N endIssuerRef() {
            return this.and();
        }
    }
}

