package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VaultKubernetesAuthBuilder extends VaultKubernetesAuthFluent<VaultKubernetesAuthBuilder> implements VisitableBuilder<VaultKubernetesAuth,VaultKubernetesAuthBuilder>{
  public VaultKubernetesAuthBuilder() {
    this(new VaultKubernetesAuth());
  }
  
  public VaultKubernetesAuthBuilder(VaultKubernetesAuthFluent<?> fluent) {
    this(fluent, new VaultKubernetesAuth());
  }
  
  public VaultKubernetesAuthBuilder(VaultKubernetesAuthFluent<?> fluent,VaultKubernetesAuth instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VaultKubernetesAuthBuilder(VaultKubernetesAuth instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VaultKubernetesAuthFluent<?> fluent;
  
  public VaultKubernetesAuth build() {
    VaultKubernetesAuth buildable = new VaultKubernetesAuth(fluent.getMountPath(),fluent.getRole(),fluent.buildSecretRef());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}