package io.fabric8.certmanager.api.model.acme.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.LinkedHashMap;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ACMEIssuerDNS01ProviderCloudflareFluent<A extends ACMEIssuerDNS01ProviderCloudflareFluent<A>> extends BaseFluent<A>{
  public ACMEIssuerDNS01ProviderCloudflareFluent() {
  }
  
  public ACMEIssuerDNS01ProviderCloudflareFluent(ACMEIssuerDNS01ProviderCloudflare instance) {
    this.copyInstance(instance);
  }
  private SecretKeySelectorBuilder apiKeySecretRef;
  private SecretKeySelectorBuilder apiTokenSecretRef;
  private String email;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ACMEIssuerDNS01ProviderCloudflare instance) {
    instance = (instance != null ? instance : new ACMEIssuerDNS01ProviderCloudflare());
    if (instance != null) {
          this.withApiKeySecretRef(instance.getApiKeySecretRef());
          this.withApiTokenSecretRef(instance.getApiTokenSecretRef());
          this.withEmail(instance.getEmail());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public SecretKeySelector buildApiKeySecretRef() {
    return this.apiKeySecretRef != null ? this.apiKeySecretRef.build() : null;
  }
  
  public A withApiKeySecretRef(SecretKeySelector apiKeySecretRef) {
    this._visitables.remove("apiKeySecretRef");
    if (apiKeySecretRef != null) {
        this.apiKeySecretRef = new SecretKeySelectorBuilder(apiKeySecretRef);
        this._visitables.get("apiKeySecretRef").add(this.apiKeySecretRef);
    } else {
        this.apiKeySecretRef = null;
        this._visitables.get("apiKeySecretRef").remove(this.apiKeySecretRef);
    }
    return (A) this;
  }
  
  public boolean hasApiKeySecretRef() {
    return this.apiKeySecretRef != null;
  }
  
  public A withNewApiKeySecretRef(String key,String name) {
    return (A)withApiKeySecretRef(new SecretKeySelector(key, name));
  }
  
  public ApiKeySecretRefNested<A> withNewApiKeySecretRef() {
    return new ApiKeySecretRefNested(null);
  }
  
  public ApiKeySecretRefNested<A> withNewApiKeySecretRefLike(SecretKeySelector item) {
    return new ApiKeySecretRefNested(item);
  }
  
  public ApiKeySecretRefNested<A> editApiKeySecretRef() {
    return withNewApiKeySecretRefLike(java.util.Optional.ofNullable(buildApiKeySecretRef()).orElse(null));
  }
  
  public ApiKeySecretRefNested<A> editOrNewApiKeySecretRef() {
    return withNewApiKeySecretRefLike(java.util.Optional.ofNullable(buildApiKeySecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ApiKeySecretRefNested<A> editOrNewApiKeySecretRefLike(SecretKeySelector item) {
    return withNewApiKeySecretRefLike(java.util.Optional.ofNullable(buildApiKeySecretRef()).orElse(item));
  }
  
  public SecretKeySelector buildApiTokenSecretRef() {
    return this.apiTokenSecretRef != null ? this.apiTokenSecretRef.build() : null;
  }
  
  public A withApiTokenSecretRef(SecretKeySelector apiTokenSecretRef) {
    this._visitables.remove("apiTokenSecretRef");
    if (apiTokenSecretRef != null) {
        this.apiTokenSecretRef = new SecretKeySelectorBuilder(apiTokenSecretRef);
        this._visitables.get("apiTokenSecretRef").add(this.apiTokenSecretRef);
    } else {
        this.apiTokenSecretRef = null;
        this._visitables.get("apiTokenSecretRef").remove(this.apiTokenSecretRef);
    }
    return (A) this;
  }
  
  public boolean hasApiTokenSecretRef() {
    return this.apiTokenSecretRef != null;
  }
  
  public A withNewApiTokenSecretRef(String key,String name) {
    return (A)withApiTokenSecretRef(new SecretKeySelector(key, name));
  }
  
  public ApiTokenSecretRefNested<A> withNewApiTokenSecretRef() {
    return new ApiTokenSecretRefNested(null);
  }
  
  public ApiTokenSecretRefNested<A> withNewApiTokenSecretRefLike(SecretKeySelector item) {
    return new ApiTokenSecretRefNested(item);
  }
  
  public ApiTokenSecretRefNested<A> editApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(null));
  }
  
  public ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRef() {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(new SecretKeySelectorBuilder().build()));
  }
  
  public ApiTokenSecretRefNested<A> editOrNewApiTokenSecretRefLike(SecretKeySelector item) {
    return withNewApiTokenSecretRefLike(java.util.Optional.ofNullable(buildApiTokenSecretRef()).orElse(item));
  }
  
  public String getEmail() {
    return this.email;
  }
  
  public A withEmail(String email) {
    this.email = email;
    return (A) this;
  }
  
  public boolean hasEmail() {
    return this.email != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ACMEIssuerDNS01ProviderCloudflareFluent that = (ACMEIssuerDNS01ProviderCloudflareFluent) o;
    if (!java.util.Objects.equals(apiKeySecretRef, that.apiKeySecretRef)) return false;
    if (!java.util.Objects.equals(apiTokenSecretRef, that.apiTokenSecretRef)) return false;
    if (!java.util.Objects.equals(email, that.email)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiKeySecretRef,  apiTokenSecretRef,  email,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiKeySecretRef != null) { sb.append("apiKeySecretRef:"); sb.append(apiKeySecretRef + ","); }
    if (apiTokenSecretRef != null) { sb.append("apiTokenSecretRef:"); sb.append(apiTokenSecretRef + ","); }
    if (email != null) { sb.append("email:"); sb.append(email + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ApiKeySecretRefNested<N> extends SecretKeySelectorFluent<ApiKeySecretRefNested<N>> implements Nested<N>{
    ApiKeySecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderCloudflareFluent.this.withApiKeySecretRef(builder.build());
    }
    
    public N endApiKeySecretRef() {
      return and();
    }
    
  
  }
  public class ApiTokenSecretRefNested<N> extends SecretKeySelectorFluent<ApiTokenSecretRefNested<N>> implements Nested<N>{
    ApiTokenSecretRefNested(SecretKeySelector item) {
      this.builder = new SecretKeySelectorBuilder(this, item);
    }
    SecretKeySelectorBuilder builder;
    
    public N and() {
      return (N) ACMEIssuerDNS01ProviderCloudflareFluent.this.withApiTokenSecretRef(builder.build());
    }
    
    public N endApiTokenSecretRef() {
      return and();
    }
    
  
  }

}