package io.fabric8.certmanager.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CertmanagerSchemaBuilder extends CertmanagerSchemaFluent<CertmanagerSchemaBuilder> implements VisitableBuilder<CertmanagerSchema,CertmanagerSchemaBuilder>{
  public CertmanagerSchemaBuilder() {
    this(new CertmanagerSchema());
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent) {
    this(fluent, new CertmanagerSchema());
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchemaFluent<?> fluent,CertmanagerSchema instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CertmanagerSchemaBuilder(CertmanagerSchema instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CertmanagerSchemaFluent<?> fluent;
  
  public CertmanagerSchema build() {
    CertmanagerSchema buildable = new CertmanagerSchema(fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEAuthorization(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolver(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverDNS01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01GatewayHTTPRoute(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01Ingress(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodObjectMeta(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressPodTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEChallengeSolverHTTP01IngressTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEExternalAccountBinding(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAcmeDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAkamai(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderAzureDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudDNS(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderCloudflare(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderDigitalOcean(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRFC2136(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderRoute53(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerDNS01ProviderWebhook(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ACMEIssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3AzureManagedIdentity(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3CertificateDNSNameSelector(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3Challenge(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3ChallengeStatus(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3Order(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderList(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderSpec(),fluent.buildGithubComJetstackCertManagerPkgApisAcmeV1alpha3OrderStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CAIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Certificate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateKeystores(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificatePrivateKey(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequest(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateRequestStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSecretTemplate(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3CertificateStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3ClusterIssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3Issuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerCondition(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerList(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerSpec(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3IssuerStatus(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3JKSKeystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3PKCS12Keystore(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3SelfSignedIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAppRole(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VaultKubernetesAuth(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiCloud(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiIssuer(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3VenafiTPP(),fluent.buildGithubComJetstackCertManagerPkgApisCertmanagerV1alpha3X509Subject(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1LocalObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1ObjectReference(),fluent.buildGithubComJetstackCertManagerPkgApisMetaV1SecretKeySelector());
    return buildable;
  }
  

}