package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateRequestListBuilder extends CertificateRequestListFluentImpl<CertificateRequestListBuilder> implements VisitableBuilder<CertificateRequestList,CertificateRequestListBuilder>{
  public CertificateRequestListBuilder() {
    this(false);
  }
  public CertificateRequestListBuilder(Boolean validationEnabled) {
    this(new CertificateRequestList(), validationEnabled);
  }
  public CertificateRequestListBuilder(CertificateRequestListFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateRequestListBuilder(CertificateRequestListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateRequestList(), validationEnabled);
  }
  public CertificateRequestListBuilder(CertificateRequestListFluent<?> fluent,CertificateRequestList instance) {
    this(fluent, instance, false);
  }
  public CertificateRequestListBuilder(CertificateRequestListFluent<?> fluent,CertificateRequestList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateRequestListBuilder(CertificateRequestList instance) {
    this(instance,false);
  }
  public CertificateRequestListBuilder(CertificateRequestList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateRequestListFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateRequestList build() {
    CertificateRequestList buildable = new CertificateRequestList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}