package io.fabric8.certmanager.api.model.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateFluentImpl<A extends CertificateFluent<A>> extends BaseFluent<A> implements CertificateFluent<A>{
  public CertificateFluentImpl() {
  }
  public CertificateFluentImpl(Certificate instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private CertificateSpecBuilder spec;
  private CertificateStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public CertificateFluent.MetadataNested<A> withNewMetadata() {
    return new CertificateFluentImpl.MetadataNestedImpl();
  }
  public CertificateFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new CertificateFluentImpl.MetadataNestedImpl(item);
  }
  public CertificateFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public CertificateFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public CertificateFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificateSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public CertificateSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(CertificateSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new CertificateSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public CertificateFluent.SpecNested<A> withNewSpec() {
    return new CertificateFluentImpl.SpecNestedImpl();
  }
  public CertificateFluent.SpecNested<A> withNewSpecLike(CertificateSpec item) {
    return new CertificateFluentImpl.SpecNestedImpl(item);
  }
  public CertificateFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public CertificateFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new CertificateSpecBuilder().build());
  }
  public CertificateFluent.SpecNested<A> editOrNewSpecLike(CertificateSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public CertificateStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public CertificateStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(CertificateStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new CertificateStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public CertificateFluent.StatusNested<A> withNewStatus() {
    return new CertificateFluentImpl.StatusNestedImpl();
  }
  public CertificateFluent.StatusNested<A> withNewStatusLike(CertificateStatus item) {
    return new CertificateFluentImpl.StatusNestedImpl(item);
  }
  public CertificateFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public CertificateFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new CertificateStatusBuilder().build());
  }
  public CertificateFluent.StatusNested<A> editOrNewStatusLike(CertificateStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CertificateFluentImpl that = (CertificateFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<CertificateFluent.MetadataNested<N>> implements CertificateFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) CertificateFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends CertificateSpecFluentImpl<CertificateFluent.SpecNested<N>> implements CertificateFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(CertificateSpec item) {
      this.builder = new CertificateSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new CertificateSpecBuilder(this);
    }
    CertificateSpecBuilder builder;
    public N and() {
      return (N) CertificateFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends CertificateStatusFluentImpl<CertificateFluent.StatusNested<N>> implements CertificateFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(CertificateStatus item) {
      this.builder = new CertificateStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new CertificateStatusBuilder(this);
    }
    CertificateStatusBuilder builder;
    public N and() {
      return (N) CertificateFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}