package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateConditionBuilder extends CertificateConditionFluentImpl<CertificateConditionBuilder> implements VisitableBuilder<CertificateCondition,CertificateConditionBuilder>{
  public CertificateConditionBuilder() {
    this(false);
  }
  public CertificateConditionBuilder(Boolean validationEnabled) {
    this(new CertificateCondition(), validationEnabled);
  }
  public CertificateConditionBuilder(CertificateConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateConditionBuilder(CertificateConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateCondition(), validationEnabled);
  }
  public CertificateConditionBuilder(CertificateConditionFluent<?> fluent,CertificateCondition instance) {
    this(fluent, instance, false);
  }
  public CertificateConditionBuilder(CertificateConditionFluent<?> fluent,CertificateCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateConditionBuilder(CertificateCondition instance) {
    this(instance,false);
  }
  public CertificateConditionBuilder(CertificateCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.validationEnabled = validationEnabled; 
  }
  CertificateConditionFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateCondition build() {
    CertificateCondition buildable = new CertificateCondition(fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}