package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultAuthBuilder extends VaultAuthFluentImpl<VaultAuthBuilder> implements VisitableBuilder<VaultAuth,io.fabric8.certmanager.api.model.v1alpha3.VaultAuthBuilder>{
  public VaultAuthBuilder() {
    this(false);
  }
  public VaultAuthBuilder(Boolean validationEnabled) {
    this(new VaultAuth(), validationEnabled);
  }
  public VaultAuthBuilder(VaultAuthFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultAuthBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAuthFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VaultAuth(), validationEnabled);
  }
  public VaultAuthBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAuthFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.VaultAuth instance) {
    this(fluent, instance, false);
  }
  public VaultAuthBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAuthFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.VaultAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAppRole(instance.getAppRole()); 
    fluent.withKubernetes(instance.getKubernetes()); 
    fluent.withTokenSecretRef(instance.getTokenSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public VaultAuthBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAuth instance) {
    this(instance,false);
  }
  public VaultAuthBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAuth instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAppRole(instance.getAppRole()); 
    this.withKubernetes(instance.getKubernetes()); 
    this.withTokenSecretRef(instance.getTokenSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha3.VaultAuthFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha3.VaultAuth build() {
    VaultAuth buildable = new VaultAuth(fluent.getAppRole(),fluent.getKubernetes(),fluent.getTokenSecretRef());
    return buildable;
  }
  
}