package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VaultAppRoleBuilder extends VaultAppRoleFluentImpl<VaultAppRoleBuilder> implements VisitableBuilder<VaultAppRole,io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleBuilder>{
  public VaultAppRoleBuilder() {
    this(false);
  }
  public VaultAppRoleBuilder(Boolean validationEnabled) {
    this(new VaultAppRole(), validationEnabled);
  }
  public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleFluent<?> fluent) {
    this(fluent, false);
  }
  public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new VaultAppRole(), validationEnabled);
  }
  public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.VaultAppRole instance) {
    this(fluent, instance, false);
  }
  public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.VaultAppRole instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPath(instance.getPath()); 
    fluent.withRoleId(instance.getRoleId()); 
    fluent.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAppRole instance) {
    this(instance,false);
  }
  public VaultAppRoleBuilder(io.fabric8.certmanager.api.model.v1alpha3.VaultAppRole instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPath(instance.getPath()); 
    this.withRoleId(instance.getRoleId()); 
    this.withSecretRef(instance.getSecretRef()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha3.VaultAppRoleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha3.VaultAppRole build() {
    VaultAppRole buildable = new VaultAppRole(fluent.getPath(),fluent.getRoleId(),fluent.getSecretRef());
    return buildable;
  }
  
}