package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSpecBuilder extends CertificateSpecFluentImpl<CertificateSpecBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha3.CertificateSpec,io.fabric8.certmanager.api.model.v1alpha3.CertificateSpecBuilder>{
  public CertificateSpecBuilder() {
    this(false);
  }
  public CertificateSpecBuilder(Boolean validationEnabled) {
    this(new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(CertificateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSpecBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CertificateSpec(), validationEnabled);
  }
  public CertificateSpecBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.CertificateSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateSpecBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateSpecFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.CertificateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommonName(instance.getCommonName()); 
    fluent.withDnsNames(instance.getDnsNames()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withEmailSANs(instance.getEmailSANs()); 
    fluent.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest()); 
    fluent.withIpAddresses(instance.getIpAddresses()); 
    fluent.withIsCA(instance.getIsCA()); 
    fluent.withIssuerRef(instance.getIssuerRef()); 
    fluent.withKeyAlgorithm(instance.getKeyAlgorithm()); 
    fluent.withKeyEncoding(instance.getKeyEncoding()); 
    fluent.withKeySize(instance.getKeySize()); 
    fluent.withKeystores(instance.getKeystores()); 
    fluent.withPrivateKey(instance.getPrivateKey()); 
    fluent.withRenewBefore(instance.getRenewBefore()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withSubject(instance.getSubject()); 
    fluent.withUriSANs(instance.getUriSANs()); 
    fluent.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateSpecBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateSpec instance) {
    this(instance,false);
  }
  public CertificateSpecBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommonName(instance.getCommonName()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withEmailSANs(instance.getEmailSANs()); 
    this.withEncodeUsagesInRequest(instance.getEncodeUsagesInRequest()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIsCA(instance.getIsCA()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.withKeyAlgorithm(instance.getKeyAlgorithm()); 
    this.withKeyEncoding(instance.getKeyEncoding()); 
    this.withKeySize(instance.getKeySize()); 
    this.withKeystores(instance.getKeystores()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withRenewBefore(instance.getRenewBefore()); 
    this.withSecretName(instance.getSecretName()); 
    this.withSubject(instance.getSubject()); 
    this.withUriSANs(instance.getUriSANs()); 
    this.withUsages(instance.getUsages()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha3.CertificateSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha3.CertificateSpec build() {
    CertificateSpec buildable = new CertificateSpec(fluent.getCommonName(),fluent.getDnsNames(),fluent.getDuration(),fluent.getEmailSANs(),fluent.getEncodeUsagesInRequest(),fluent.getIpAddresses(),fluent.getIsCA(),fluent.getIssuerRef(),fluent.getKeyAlgorithm(),fluent.getKeyEncoding(),fluent.getKeySize(),fluent.getKeystores(),fluent.getPrivateKey(),fluent.getRenewBefore(),fluent.getSecretName(),fluent.getSubject(),fluent.getUriSANs(),fluent.getUsages());
    return buildable;
  }
  
}