package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateBuilder extends CertificateFluentImpl<CertificateBuilder> implements VisitableBuilder<Certificate,io.fabric8.certmanager.api.model.v1alpha3.CertificateBuilder>{
  public CertificateBuilder() {
    this(false);
  }
  public CertificateBuilder(Boolean validationEnabled) {
    this(new Certificate(), validationEnabled);
  }
  public CertificateBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Certificate(), validationEnabled);
  }
  public CertificateBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.Certificate instance) {
    this(fluent, instance, false);
  }
  public CertificateBuilder(io.fabric8.certmanager.api.model.v1alpha3.CertificateFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.Certificate instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public CertificateBuilder(io.fabric8.certmanager.api.model.v1alpha3.Certificate instance) {
    this(instance,false);
  }
  public CertificateBuilder(io.fabric8.certmanager.api.model.v1alpha3.Certificate instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha3.CertificateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha3.Certificate build() {
    Certificate buildable = new Certificate(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}