package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CAIssuerBuilder extends CAIssuerFluentImpl<CAIssuerBuilder> implements VisitableBuilder<CAIssuer,io.fabric8.certmanager.api.model.v1alpha3.CAIssuerBuilder>{
  public CAIssuerBuilder() {
    this(false);
  }
  public CAIssuerBuilder(Boolean validationEnabled) {
    this(new CAIssuer(), validationEnabled);
  }
  public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.CAIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.CAIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CAIssuer(), validationEnabled);
  }
  public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.CAIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.CAIssuer instance) {
    this(fluent, instance, false);
  }
  public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.CAIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.CAIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
    fluent.withSecretName(instance.getSecretName()); 
    this.validationEnabled = validationEnabled; 
  }
  public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.CAIssuer instance) {
    this(instance,false);
  }
  public CAIssuerBuilder(io.fabric8.certmanager.api.model.v1alpha3.CAIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCrlDistributionPoints(instance.getCrlDistributionPoints()); 
    this.withSecretName(instance.getSecretName()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.v1alpha3.CAIssuerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.v1alpha3.CAIssuer build() {
    CAIssuer buildable = new CAIssuer(fluent.getCrlDistributionPoints(),fluent.getSecretName());
    return buildable;
  }
  
}