package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OrderStatusBuilder extends OrderStatusFluentImpl<OrderStatusBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatus,io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatusBuilder>{
  public OrderStatusBuilder() {
    this(false);
  }
  public OrderStatusBuilder(Boolean validationEnabled) {
    this(new OrderStatus(), validationEnabled);
  }
  public OrderStatusBuilder(OrderStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public OrderStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OrderStatus(), validationEnabled);
  }
  public OrderStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatusFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatus instance) {
    this(fluent, instance, false);
  }
  public OrderStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatusFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthorizations(instance.getAuthorizations()); 
    fluent.withCertificate(instance.getCertificate()); 
    fluent.withFailureTime(instance.getFailureTime()); 
    fluent.withFinalizeURL(instance.getFinalizeURL()); 
    fluent.withReason(instance.getReason()); 
    fluent.withState(instance.getState()); 
    fluent.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  public OrderStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatus instance) {
    this(instance,false);
  }
  public OrderStatusBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthorizations(instance.getAuthorizations()); 
    this.withCertificate(instance.getCertificate()); 
    this.withFailureTime(instance.getFailureTime()); 
    this.withFinalizeURL(instance.getFinalizeURL()); 
    this.withReason(instance.getReason()); 
    this.withState(instance.getState()); 
    this.withUrl(instance.getUrl()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.acme.v1alpha3.OrderStatus build() {
    OrderStatus buildable = new OrderStatus(fluent.getAuthorizations(),fluent.getCertificate(),fluent.getFailureTime(),fluent.getFinalizeURL(),fluent.getReason(),fluent.getState(),fluent.getUrl());
    return buildable;
  }
  
}