package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OrderSpecBuilder extends OrderSpecFluentImpl<OrderSpecBuilder> implements VisitableBuilder<OrderSpec,io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpecBuilder>{
  public OrderSpecBuilder() {
    this(false);
  }
  public OrderSpecBuilder(Boolean validationEnabled) {
    this(new OrderSpec(), validationEnabled);
  }
  public OrderSpecBuilder(OrderSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public OrderSpecBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new OrderSpec(), validationEnabled);
  }
  public OrderSpecBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpecFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpec instance) {
    this(fluent, instance, false);
  }
  public OrderSpecBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpecFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCommonName(instance.getCommonName()); 
    fluent.withCsr(instance.getCsr()); 
    fluent.withDnsNames(instance.getDnsNames()); 
    fluent.withDuration(instance.getDuration()); 
    fluent.withIpAddresses(instance.getIpAddresses()); 
    fluent.withIssuerRef(instance.getIssuerRef()); 
    this.validationEnabled = validationEnabled; 
  }
  public OrderSpecBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpec instance) {
    this(instance,false);
  }
  public OrderSpecBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCommonName(instance.getCommonName()); 
    this.withCsr(instance.getCsr()); 
    this.withDnsNames(instance.getDnsNames()); 
    this.withDuration(instance.getDuration()); 
    this.withIpAddresses(instance.getIpAddresses()); 
    this.withIssuerRef(instance.getIssuerRef()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.acme.v1alpha3.OrderSpec build() {
    OrderSpec buildable = new OrderSpec(fluent.getCommonName(),fluent.getCsr(),fluent.getDnsNames(),fluent.getDuration(),fluent.getIpAddresses(),fluent.getIssuerRef());
    return buildable;
  }
  
}