package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import java.lang.Integer;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ACMEIssuerFluentImpl<A extends ACMEIssuerFluent<A>> extends BaseFluent<A> implements ACMEIssuerFluent<A>{
  public ACMEIssuerFluentImpl() {
  }
  public ACMEIssuerFluentImpl(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer instance) {
    this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration()); 
    this.withEmail(instance.getEmail()); 
    this.withEnableDurationFeature(instance.getEnableDurationFeature()); 
    this.withExternalAccountBinding(instance.getExternalAccountBinding()); 
    this.withPreferredChain(instance.getPreferredChain()); 
    this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef()); 
    this.withServer(instance.getServer()); 
    this.withSkipTLSVerify(instance.getSkipTLSVerify()); 
    this.withSolvers(instance.getSolvers()); 
  }
  private Boolean disableAccountKeyGeneration;
  private String email;
  private java.lang.Boolean enableDurationFeature;
  private ACMEExternalAccountBindingBuilder externalAccountBinding;
  private java.lang.String preferredChain;
  private SecretKeySelectorBuilder privateKeySecretRef;
  private java.lang.String server;
  private java.lang.Boolean skipTLSVerify;
  private ArrayList<ACMEChallengeSolverBuilder> solvers = new java.util.ArrayList<ACMEChallengeSolverBuilder>();
  public java.lang.Boolean getDisableAccountKeyGeneration() {
    return this.disableAccountKeyGeneration;
  }
  public A withDisableAccountKeyGeneration(java.lang.Boolean disableAccountKeyGeneration) {
    this.disableAccountKeyGeneration=disableAccountKeyGeneration; return (A) this;
  }
  public java.lang.Boolean hasDisableAccountKeyGeneration() {
    return this.disableAccountKeyGeneration != null;
  }
  public java.lang.String getEmail() {
    return this.email;
  }
  public A withEmail(java.lang.String email) {
    this.email=email; return (A) this;
  }
  public java.lang.Boolean hasEmail() {
    return this.email != null;
  }
  public java.lang.Boolean getEnableDurationFeature() {
    return this.enableDurationFeature;
  }
  public A withEnableDurationFeature(java.lang.Boolean enableDurationFeature) {
    this.enableDurationFeature=enableDurationFeature; return (A) this;
  }
  public java.lang.Boolean hasEnableDurationFeature() {
    return this.enableDurationFeature != null;
  }
  
  /**
   * This method has been deprecated, please use method buildExternalAccountBinding instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBinding getExternalAccountBinding() {
    return this.externalAccountBinding!=null ?this.externalAccountBinding.build():null;
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBinding buildExternalAccountBinding() {
    return this.externalAccountBinding!=null ?this.externalAccountBinding.build():null;
  }
  public A withExternalAccountBinding(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBinding externalAccountBinding) {
    _visitables.get("externalAccountBinding").remove(this.externalAccountBinding);
    if (externalAccountBinding!=null){ this.externalAccountBinding= new ACMEExternalAccountBindingBuilder(externalAccountBinding); _visitables.get("externalAccountBinding").add(this.externalAccountBinding);} return (A) this;
  }
  public java.lang.Boolean hasExternalAccountBinding() {
    return this.externalAccountBinding != null;
  }
  public ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBinding() {
    return new ACMEIssuerFluentImpl.ExternalAccountBindingNestedImpl();
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.ExternalAccountBindingNested<A> withNewExternalAccountBindingLike(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBinding item) {
    return new ACMEIssuerFluentImpl.ExternalAccountBindingNestedImpl(item);
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.ExternalAccountBindingNested<A> editExternalAccountBinding() {
    return withNewExternalAccountBindingLike(getExternalAccountBinding());
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBinding() {
    return withNewExternalAccountBindingLike(getExternalAccountBinding() != null ? getExternalAccountBinding(): new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBindingBuilder().build());
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.ExternalAccountBindingNested<A> editOrNewExternalAccountBindingLike(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBinding item) {
    return withNewExternalAccountBindingLike(getExternalAccountBinding() != null ? getExternalAccountBinding(): item);
  }
  public java.lang.String getPreferredChain() {
    return this.preferredChain;
  }
  public A withPreferredChain(java.lang.String preferredChain) {
    this.preferredChain=preferredChain; return (A) this;
  }
  public java.lang.Boolean hasPreferredChain() {
    return this.preferredChain != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPrivateKeySecretRef instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector getPrivateKeySecretRef() {
    return this.privateKeySecretRef!=null ?this.privateKeySecretRef.build():null;
  }
  public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector buildPrivateKeySecretRef() {
    return this.privateKeySecretRef!=null ?this.privateKeySecretRef.build():null;
  }
  public A withPrivateKeySecretRef(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector privateKeySecretRef) {
    _visitables.get("privateKeySecretRef").remove(this.privateKeySecretRef);
    if (privateKeySecretRef!=null){ this.privateKeySecretRef= new SecretKeySelectorBuilder(privateKeySecretRef); _visitables.get("privateKeySecretRef").add(this.privateKeySecretRef);} return (A) this;
  }
  public java.lang.Boolean hasPrivateKeySecretRef() {
    return this.privateKeySecretRef != null;
  }
  public A withNewPrivateKeySecretRef(java.lang.String key,java.lang.String name) {
    return (A)withPrivateKeySecretRef(new SecretKeySelector(key, name));
  }
  public ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRef() {
    return new ACMEIssuerFluentImpl.PrivateKeySecretRefNestedImpl();
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.PrivateKeySecretRefNested<A> withNewPrivateKeySecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
    return new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluentImpl.PrivateKeySecretRefNestedImpl(item);
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.PrivateKeySecretRefNested<A> editPrivateKeySecretRef() {
    return withNewPrivateKeySecretRefLike(getPrivateKeySecretRef());
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRef() {
    return withNewPrivateKeySecretRefLike(getPrivateKeySecretRef() != null ? getPrivateKeySecretRef(): new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder().build());
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.PrivateKeySecretRefNested<A> editOrNewPrivateKeySecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
    return withNewPrivateKeySecretRefLike(getPrivateKeySecretRef() != null ? getPrivateKeySecretRef(): item);
  }
  public java.lang.String getServer() {
    return this.server;
  }
  public A withServer(java.lang.String server) {
    this.server=server; return (A) this;
  }
  public java.lang.Boolean hasServer() {
    return this.server != null;
  }
  public java.lang.Boolean getSkipTLSVerify() {
    return this.skipTLSVerify;
  }
  public A withSkipTLSVerify(java.lang.Boolean skipTLSVerify) {
    this.skipTLSVerify=skipTLSVerify; return (A) this;
  }
  public java.lang.Boolean hasSkipTLSVerify() {
    return this.skipTLSVerify != null;
  }
  public A addToSolvers(Integer index,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item) {
    if (this.solvers == null) {this.solvers = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder>();}
    io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(index >= 0 ? index : _visitables.get("solvers").size(), builder);this.solvers.add(index >= 0 ? index : solvers.size(), builder); return (A)this;
  }
  public A setToSolvers(java.lang.Integer index,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item) {
    if (this.solvers == null) {this.solvers = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder>();}
    io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder(item);
    if (index < 0 || index >= _visitables.get("solvers").size()) { _visitables.get("solvers").add(builder); } else { _visitables.get("solvers").set(index, builder);}
    if (index < 0 || index >= solvers.size()) { solvers.add(builder); } else { solvers.set(index, builder);}
     return (A)this;
  }
  public A addToSolvers(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver... items) {
    if (this.solvers == null) {this.solvers = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder>();}
    for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item : items) {io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(builder);this.solvers.add(builder);} return (A)this;
  }
  public A addAllToSolvers(Collection<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver> items) {
    if (this.solvers == null) {this.solvers = new java.util.ArrayList<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder>();}
    for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item : items) {io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder(item);_visitables.get("solvers").add(builder);this.solvers.add(builder);} return (A)this;
  }
  public A removeFromSolvers(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver... items) {
    for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item : items) {io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder(item);_visitables.get("solvers").remove(builder);if (this.solvers != null) {this.solvers.remove(builder);}} return (A)this;
  }
  public A removeAllFromSolvers(java.util.Collection<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver> items) {
    for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item : items) {io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder(item);_visitables.get("solvers").remove(builder);if (this.solvers != null) {this.solvers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSolvers(Predicate<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder> predicate) {
    if (solvers == null) return (A) this;
    final Iterator<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder> each = solvers.iterator();
    final List visitables = _visitables.get("solvers");
    while (each.hasNext()) {
      io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSolvers instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public List<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver> getSolvers() {
    return solvers != null ? build(solvers) : null;
  }
  public java.util.List<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver> buildSolvers() {
    return solvers != null ? build(solvers) : null;
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver buildSolver(java.lang.Integer index) {
    return this.solvers.get(index).build();
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver buildFirstSolver() {
    return this.solvers.get(0).build();
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver buildLastSolver() {
    return this.solvers.get(solvers.size() - 1).build();
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver buildMatchingSolver(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder> predicate) {
    for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder item: solvers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingSolver(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder> predicate) {
    for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder item: solvers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSolvers(java.util.List<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver> solvers) {
    if (this.solvers != null) { _visitables.get("solvers").removeAll(this.solvers);}
    if (solvers != null) {this.solvers = new java.util.ArrayList(); for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item : solvers){this.addToSolvers(item);}} else { this.solvers = null;} return (A) this;
  }
  public A withSolvers(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver... solvers) {
    if (this.solvers != null) {this.solvers.clear();}
    if (solvers != null) {for (io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item :solvers){ this.addToSolvers(item);}} return (A) this;
  }
  public java.lang.Boolean hasSolvers() {
    return solvers != null && !solvers.isEmpty();
  }
  public ACMEIssuerFluent.SolversNested<A> addNewSolver() {
    return new ACMEIssuerFluentImpl.SolversNestedImpl();
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.SolversNested<A> addNewSolverLike(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item) {
    return new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluentImpl.SolversNestedImpl(-1, item);
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.SolversNested<A> setNewSolverLike(java.lang.Integer index,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolver item) {
    return new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluentImpl.SolversNestedImpl(index, item);
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.SolversNested<A> editSolver(java.lang.Integer index) {
    if (solvers.size() <= index) throw new RuntimeException("Can't edit solvers. Index exceeds size.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.SolversNested<A> editFirstSolver() {
    if (solvers.size() == 0) throw new RuntimeException("Can't edit first solvers. The list is empty.");
    return setNewSolverLike(0, buildSolver(0));
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.SolversNested<A> editLastSolver() {
    int index = solvers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last solvers. The list is empty.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.SolversNested<A> editMatchingSolver(java.util.function.Predicate<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder> predicate) {
    int index = -1;
    for (int i=0;i<solvers.size();i++) { 
    if (predicate.test(solvers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching solvers. No match found.");
    return setNewSolverLike(index, buildSolver(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ACMEIssuerFluentImpl that = (ACMEIssuerFluentImpl) o;
    if (disableAccountKeyGeneration != null ? !disableAccountKeyGeneration.equals(that.disableAccountKeyGeneration) :that.disableAccountKeyGeneration != null) return false;
    if (email != null ? !email.equals(that.email) :that.email != null) return false;
    if (enableDurationFeature != null ? !enableDurationFeature.equals(that.enableDurationFeature) :that.enableDurationFeature != null) return false;
    if (externalAccountBinding != null ? !externalAccountBinding.equals(that.externalAccountBinding) :that.externalAccountBinding != null) return false;
    if (preferredChain != null ? !preferredChain.equals(that.preferredChain) :that.preferredChain != null) return false;
    if (privateKeySecretRef != null ? !privateKeySecretRef.equals(that.privateKeySecretRef) :that.privateKeySecretRef != null) return false;
    if (server != null ? !server.equals(that.server) :that.server != null) return false;
    if (skipTLSVerify != null ? !skipTLSVerify.equals(that.skipTLSVerify) :that.skipTLSVerify != null) return false;
    if (solvers != null ? !solvers.equals(that.solvers) :that.solvers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(disableAccountKeyGeneration,  email,  enableDurationFeature,  externalAccountBinding,  preferredChain,  privateKeySecretRef,  server,  skipTLSVerify,  solvers,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (disableAccountKeyGeneration != null) { sb.append("disableAccountKeyGeneration:"); sb.append(disableAccountKeyGeneration + ","); }
    if (email != null) { sb.append("email:"); sb.append(email + ","); }
    if (enableDurationFeature != null) { sb.append("enableDurationFeature:"); sb.append(enableDurationFeature + ","); }
    if (externalAccountBinding != null) { sb.append("externalAccountBinding:"); sb.append(externalAccountBinding + ","); }
    if (preferredChain != null) { sb.append("preferredChain:"); sb.append(preferredChain + ","); }
    if (privateKeySecretRef != null) { sb.append("privateKeySecretRef:"); sb.append(privateKeySecretRef + ","); }
    if (server != null) { sb.append("server:"); sb.append(server + ","); }
    if (skipTLSVerify != null) { sb.append("skipTLSVerify:"); sb.append(skipTLSVerify + ","); }
    if (solvers != null && !solvers.isEmpty()) { sb.append("solvers:"); sb.append(solvers); }
    sb.append("}");
    return sb.toString();
  }
  public A withDisableAccountKeyGeneration() {
    return withDisableAccountKeyGeneration(true);
  }
  public A withEnableDurationFeature() {
    return withEnableDurationFeature(true);
  }
  public A withSkipTLSVerify() {
    return withSkipTLSVerify(true);
  }
  class ExternalAccountBindingNestedImpl<N> extends ACMEExternalAccountBindingFluentImpl<ACMEIssuerFluent.ExternalAccountBindingNested<N>> implements io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.ExternalAccountBindingNested<N>,Nested<N>{
    ExternalAccountBindingNestedImpl(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBinding item) {
      this.builder = new ACMEExternalAccountBindingBuilder(this, item);
    }
    ExternalAccountBindingNestedImpl() {
      this.builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBindingBuilder(this);
    }
    io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEExternalAccountBindingBuilder builder;
    public N and() {
      return (N) ACMEIssuerFluentImpl.this.withExternalAccountBinding(builder.build());
    }
    public N endExternalAccountBinding() {
      return and();
    }
    
  }
  class PrivateKeySecretRefNestedImpl<N> extends SecretKeySelectorFluentImpl<ACMEIssuerFluent.PrivateKeySecretRefNested<N>> implements io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.PrivateKeySecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PrivateKeySecretRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
      this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this, item);
    }
    PrivateKeySecretRefNestedImpl() {
      this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this);
    }
    io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder builder;
    public N and() {
      return (N) ACMEIssuerFluentImpl.this.withPrivateKeySecretRef(builder.build());
    }
    public N endPrivateKeySecretRef() {
      return and();
    }
    
  }
  class SolversNestedImpl<N> extends ACMEChallengeSolverFluentImpl<ACMEIssuerFluent.SolversNested<N>> implements io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent.SolversNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SolversNestedImpl(java.lang.Integer index,ACMEChallengeSolver item) {
      this.index = index;
      this.builder = new ACMEChallengeSolverBuilder(this, item);
    }
    SolversNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder(this);
    }
    io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEChallengeSolverBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) ACMEIssuerFluentImpl.this.setToSolvers(index,builder.build());
    }
    public N endSolver() {
      return and();
    }
    
  }
  
}