package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEIssuerBuilder extends ACMEIssuerFluentImpl<ACMEIssuerBuilder> implements VisitableBuilder<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerBuilder>{
  public ACMEIssuerBuilder() {
    this(false);
  }
  public ACMEIssuerBuilder(Boolean validationEnabled) {
    this(new ACMEIssuer(), validationEnabled);
  }
  public ACMEIssuerBuilder(ACMEIssuerFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ACMEIssuer(), validationEnabled);
  }
  public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer instance) {
    this(fluent, instance, false);
  }
  public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration()); 
    fluent.withEmail(instance.getEmail()); 
    fluent.withEnableDurationFeature(instance.getEnableDurationFeature()); 
    fluent.withExternalAccountBinding(instance.getExternalAccountBinding()); 
    fluent.withPreferredChain(instance.getPreferredChain()); 
    fluent.withPrivateKeySecretRef(instance.getPrivateKeySecretRef()); 
    fluent.withServer(instance.getServer()); 
    fluent.withSkipTLSVerify(instance.getSkipTLSVerify()); 
    fluent.withSolvers(instance.getSolvers()); 
    this.validationEnabled = validationEnabled; 
  }
  public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer instance) {
    this(instance,false);
  }
  public ACMEIssuerBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisableAccountKeyGeneration(instance.getDisableAccountKeyGeneration()); 
    this.withEmail(instance.getEmail()); 
    this.withEnableDurationFeature(instance.getEnableDurationFeature()); 
    this.withExternalAccountBinding(instance.getExternalAccountBinding()); 
    this.withPreferredChain(instance.getPreferredChain()); 
    this.withPrivateKeySecretRef(instance.getPrivateKeySecretRef()); 
    this.withServer(instance.getServer()); 
    this.withSkipTLSVerify(instance.getSkipTLSVerify()); 
    this.withSolvers(instance.getSolvers()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuer build() {
    ACMEIssuer buildable = new ACMEIssuer(fluent.getDisableAccountKeyGeneration(),fluent.getEmail(),fluent.getEnableDurationFeature(),fluent.getExternalAccountBinding(),fluent.getPreferredChain(),fluent.getPrivateKeySecretRef(),fluent.getServer(),fluent.getSkipTLSVerify(),fluent.getSolvers());
    return buildable;
  }
  
}