package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ACMEAuthorizationBuilder extends ACMEAuthorizationFluentImpl<ACMEAuthorizationBuilder> implements VisitableBuilder<ACMEAuthorization,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorizationBuilder>{
  public ACMEAuthorizationBuilder() {
    this(false);
  }
  public ACMEAuthorizationBuilder(Boolean validationEnabled) {
    this(new ACMEAuthorization(), validationEnabled);
  }
  public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorizationFluent<?> fluent) {
    this(fluent, false);
  }
  public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorizationFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ACMEAuthorization(), validationEnabled);
  }
  public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorizationFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization instance) {
    this(fluent, instance, false);
  }
  public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorizationFluent<?> fluent,io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withChallenges(instance.getChallenges()); 
    fluent.withIdentifier(instance.getIdentifier()); 
    fluent.withInitialState(instance.getInitialState()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withWildcard(instance.getWildcard()); 
    this.validationEnabled = validationEnabled; 
  }
  public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization instance) {
    this(instance,false);
  }
  public ACMEAuthorizationBuilder(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withChallenges(instance.getChallenges()); 
    this.withIdentifier(instance.getIdentifier()); 
    this.withInitialState(instance.getInitialState()); 
    this.withUrl(instance.getUrl()); 
    this.withWildcard(instance.getWildcard()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorizationFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEAuthorization build() {
    ACMEAuthorization buildable = new ACMEAuthorization(fluent.getChallenges(),fluent.getIdentifier(),fluent.getInitialState(),fluent.getUrl(),fluent.getWildcard());
    return buildable;
  }
  
}