package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IssuerStatusBuilder extends io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusFluentImpl<io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.v1alpha3.IssuerStatus,io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusBuilder> {

    io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IssuerStatusBuilder() {
        this(true);
    }

    public IssuerStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new IssuerStatus(), validationEnabled);
    }

    public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IssuerStatus(), validationEnabled);
    }

    public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.IssuerStatus instance) {
        this(fluent, instance, true);
    }

    public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1alpha3.IssuerStatusFluent<?> fluent,io.fabric8.certmanager.api.model.v1alpha3.IssuerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAcme(instance.getAcme()); 
        fluent.withConditions(instance.getConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1alpha3.IssuerStatus instance) {
        this(instance,true);
    }

    public IssuerStatusBuilder(io.fabric8.certmanager.api.model.v1alpha3.IssuerStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAcme(instance.getAcme()); 
        this.withConditions(instance.getConditions()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.v1alpha3.EditableIssuerStatus build() {
        EditableIssuerStatus buildable = new EditableIssuerStatus(fluent.getAcme(),fluent.getConditions());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IssuerStatusBuilder that = (IssuerStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
