package io.fabric8.certmanager.api.model.acme.v1alpha3;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import java.lang.Deprecated;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;

public class ACMEIssuerDNS01ProviderCloudDNSFluentImpl<A extends io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent<A> {

    private java.lang.String hostedZoneName;
    private java.lang.String project;
    private io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder serviceAccountSecretRef;

    public ACMEIssuerDNS01ProviderCloudDNSFluentImpl() {
    }

    public ACMEIssuerDNS01ProviderCloudDNSFluentImpl(io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNS instance) {
        this.withHostedZoneName(instance.getHostedZoneName()); 
        this.withProject(instance.getProject()); 
        this.withServiceAccountSecretRef(instance.getServiceAccountSecretRef()); 
    }

    public java.lang.String getHostedZoneName() {
        return this.hostedZoneName;
    }

    public A withHostedZoneName(java.lang.String hostedZoneName) {
        this.hostedZoneName=hostedZoneName; return (A) this;
    }

    public java.lang.Boolean hasHostedZoneName() {
        return this.hostedZoneName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHostedZoneName instead.
     */
        public A withNewHostedZoneName(java.lang.String arg0) {
        return (A)withHostedZoneName(new String(arg0));
    }

    public java.lang.String getProject() {
        return this.project;
    }

    public A withProject(java.lang.String project) {
        this.project=project; return (A) this;
    }

    public java.lang.Boolean hasProject() {
        return this.project != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withProject instead.
     */
        public A withNewProject(java.lang.String arg0) {
        return (A)withProject(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccountSecretRef instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector getServiceAccountSecretRef() {
        return this.serviceAccountSecretRef!=null?this.serviceAccountSecretRef.build():null;
    }

    public io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector buildServiceAccountSecretRef() {
        return this.serviceAccountSecretRef!=null?this.serviceAccountSecretRef.build():null;
    }

    public A withServiceAccountSecretRef(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector serviceAccountSecretRef) {
        _visitables.get("serviceAccountSecretRef").remove(this.serviceAccountSecretRef);
        if (serviceAccountSecretRef!=null){ this.serviceAccountSecretRef= new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(serviceAccountSecretRef); _visitables.get("serviceAccountSecretRef").add(this.serviceAccountSecretRef);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccountSecretRef() {
        return this.serviceAccountSecretRef != null;
    }

    public A withNewServiceAccountSecretRef(java.lang.String key,java.lang.String name) {
        return (A)withServiceAccountSecretRef(new SecretKeySelector(key, name));
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> withNewServiceAccountSecretRef() {
        return new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluentImpl.ServiceAccountSecretRefNestedImpl();
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> withNewServiceAccountSecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return new io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluentImpl.ServiceAccountSecretRefNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> editServiceAccountSecretRef() {
        return withNewServiceAccountSecretRefLike(getServiceAccountSecretRef());
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> editOrNewServiceAccountSecretRef() {
        return withNewServiceAccountSecretRefLike(getServiceAccountSecretRef() != null ? getServiceAccountSecretRef(): new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder().build());
    }

    public io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<A> editOrNewServiceAccountSecretRefLike(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
        return withNewServiceAccountSecretRefLike(getServiceAccountSecretRef() != null ? getServiceAccountSecretRef(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ACMEIssuerDNS01ProviderCloudDNSFluentImpl that = (ACMEIssuerDNS01ProviderCloudDNSFluentImpl) o;
        if (hostedZoneName != null ? !hostedZoneName.equals(that.hostedZoneName) :that.hostedZoneName != null) return false;
        if (project != null ? !project.equals(that.project) :that.project != null) return false;
        if (serviceAccountSecretRef != null ? !serviceAccountSecretRef.equals(that.serviceAccountSecretRef) :that.serviceAccountSecretRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(hostedZoneName,  project,  serviceAccountSecretRef,  super.hashCode());
    }

    public class ServiceAccountSecretRefNestedImpl<N> extends io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorFluentImpl<io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<N>> implements io.fabric8.certmanager.api.model.acme.v1alpha3.ACMEIssuerDNS01ProviderCloudDNSFluent.ServiceAccountSecretRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder builder;

            ServiceAccountSecretRefNestedImpl(io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector item) {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this, item);
                        
            }

            ServiceAccountSecretRefNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder(this);
                        
            }

            public N and() {
                return (N) ACMEIssuerDNS01ProviderCloudDNSFluentImpl.this.withServiceAccountSecretRef(builder.build());
            }

            public N endServiceAccountSecretRef() {
                return and();
            }
    }


}
