package io.fabric8.certmanager.api.model.meta.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ObjectReferenceBuilder extends io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluentImpl<io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.certmanager.api.model.meta.v1.ObjectReference,io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder> {

    io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ObjectReferenceBuilder() {
        this(true);
    }

    public ObjectReferenceBuilder(java.lang.Boolean validationEnabled) {
        this(new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent<?> fluent) {
        this(fluent, true);
    }

    public ObjectReferenceBuilder(io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ObjectReference(), validationEnabled);
    }

    public ObjectReferenceBuilder(io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent<?> fluent,io.fabric8.certmanager.api.model.meta.v1.ObjectReference instance) {
        this(fluent, instance, true);
    }

    public ObjectReferenceBuilder(io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceFluent<?> fluent,io.fabric8.certmanager.api.model.meta.v1.ObjectReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withGroup(instance.getGroup()); 
        fluent.withKind(instance.getKind()); 
        fluent.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public ObjectReferenceBuilder(io.fabric8.certmanager.api.model.meta.v1.ObjectReference instance) {
        this(instance,true);
    }

    public ObjectReferenceBuilder(io.fabric8.certmanager.api.model.meta.v1.ObjectReference instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withGroup(instance.getGroup()); 
        this.withKind(instance.getKind()); 
        this.withName(instance.getName()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.certmanager.api.model.meta.v1.EditableObjectReference build() {
        EditableObjectReference buildable = new EditableObjectReference(fluent.getGroup(),fluent.getKind(),fluent.getName());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ObjectReferenceBuilder that = (ObjectReferenceBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
