package io.fabric8.certmanager.api.model.v1alpha3;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class VaultIssuerFluentImpl<A extends io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent<A> {

    private io.fabric8.certmanager.api.model.v1alpha3.VaultAuthBuilder auth;
    private java.util.List<java.lang.Integer> caBundle;
    private java.lang.String namespace;
    private java.lang.String path;
    private java.lang.String server;

    public VaultIssuerFluentImpl() {
    }

    public VaultIssuerFluentImpl(io.fabric8.certmanager.api.model.v1alpha3.VaultIssuer instance) {
        this.withAuth(instance.getAuth()); 
        this.withCaBundle(instance.getCaBundle()); 
        this.withNamespace(instance.getNamespace()); 
        this.withPath(instance.getPath()); 
        this.withServer(instance.getServer()); 
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildAuth instead.
     * @return The buildable object.
     */
        public io.fabric8.certmanager.api.model.v1alpha3.VaultAuth getAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public io.fabric8.certmanager.api.model.v1alpha3.VaultAuth buildAuth() {
        return this.auth!=null?this.auth.build():null;
    }

    public A withAuth(io.fabric8.certmanager.api.model.v1alpha3.VaultAuth auth) {
        _visitables.get("auth").remove(this.auth);
        if (auth!=null){ this.auth= new io.fabric8.certmanager.api.model.v1alpha3.VaultAuthBuilder(auth); _visitables.get("auth").add(this.auth);} return (A) this;
    }

    public java.lang.Boolean hasAuth() {
        return this.auth != null;
    }

    public io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent.AuthNested<A> withNewAuth() {
        return new io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluentImpl.AuthNestedImpl();
    }

    public io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent.AuthNested<A> withNewAuthLike(io.fabric8.certmanager.api.model.v1alpha3.VaultAuth item) {
        return new io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluentImpl.AuthNestedImpl(item);
    }

    public io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent.AuthNested<A> editAuth() {
        return withNewAuthLike(getAuth());
    }

    public io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent.AuthNested<A> editOrNewAuth() {
        return withNewAuthLike(getAuth() != null ? getAuth(): new io.fabric8.certmanager.api.model.v1alpha3.VaultAuthBuilder().build());
    }

    public io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent.AuthNested<A> editOrNewAuthLike(io.fabric8.certmanager.api.model.v1alpha3.VaultAuth item) {
        return withNewAuthLike(getAuth() != null ? getAuth(): item);
    }

    public A addToCaBundle(int index,java.lang.Integer item) {
        if (this.caBundle == null) {this.caBundle = new java.util.ArrayList<java.lang.Integer>();}
        this.caBundle.add(index, item);
        return (A)this;
    }

    public A setToCaBundle(int index,java.lang.Integer item) {
        if (this.caBundle == null) {this.caBundle = new java.util.ArrayList<java.lang.Integer>();}
        this.caBundle.set(index, item); return (A)this;
    }

    public A addToCaBundle(java.lang.Integer... items) {
        if (this.caBundle == null) {this.caBundle = new java.util.ArrayList<java.lang.Integer>();}
        for (java.lang.Integer item : items) {this.caBundle.add(item);} return (A)this;
    }

    public A addAllToCaBundle(java.util.Collection<java.lang.Integer> items) {
        if (this.caBundle == null) {this.caBundle = new java.util.ArrayList<java.lang.Integer>();}
        for (java.lang.Integer item : items) {this.caBundle.add(item);} return (A)this;
    }

    public A removeFromCaBundle(java.lang.Integer... items) {
        for (java.lang.Integer item : items) {if (this.caBundle!= null){ this.caBundle.remove(item);}} return (A)this;
    }

    public A removeAllFromCaBundle(java.util.Collection<java.lang.Integer> items) {
        for (java.lang.Integer item : items) {if (this.caBundle!= null){ this.caBundle.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.Integer> getCaBundle() {
        return this.caBundle;
    }

    public java.lang.Integer getCaBundle(int index) {
        return this.caBundle.get(index);
    }

    public java.lang.Integer getFirstCaBundle() {
        return this.caBundle.get(0);
    }

    public java.lang.Integer getLastCaBundle() {
        return this.caBundle.get(caBundle.size() - 1);
    }

    public java.lang.Integer getMatchingCaBundle(java.util.function.Predicate<java.lang.Integer> predicate) {
        for (java.lang.Integer item: caBundle) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingCaBundle(java.util.function.Predicate<java.lang.Integer> predicate) {
        for (java.lang.Integer item: caBundle) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withCaBundle(java.util.List<java.lang.Integer> caBundle) {
        if (this.caBundle != null) { _visitables.get("caBundle").removeAll(this.caBundle);}
        if (caBundle != null) {this.caBundle = new java.util.ArrayList<java.lang.Integer>(); for (java.lang.Integer item : caBundle){this.addToCaBundle(item);}} else { this.caBundle = null;} return (A) this;
    }

    public A withCaBundle(java.lang.Integer... caBundle) {
        if (this.caBundle != null) {this.caBundle.clear();}
        if (caBundle != null) {for (java.lang.Integer item :caBundle){ this.addToCaBundle(item);}} return (A) this;
    }

    public java.lang.Boolean hasCaBundle() {
        return caBundle != null && !caBundle.isEmpty();
    }

    public java.lang.String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(java.lang.String namespace) {
        this.namespace=namespace; return (A) this;
    }

    public java.lang.Boolean hasNamespace() {
        return this.namespace != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withNamespace instead.
     */
        public A withNewNamespace(java.lang.String arg0) {
        return (A)withNamespace(new String(arg0));
    }

    public java.lang.String getPath() {
        return this.path;
    }

    public A withPath(java.lang.String path) {
        this.path=path; return (A) this;
    }

    public java.lang.Boolean hasPath() {
        return this.path != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPath instead.
     */
        public A withNewPath(java.lang.String arg0) {
        return (A)withPath(new String(arg0));
    }

    public java.lang.String getServer() {
        return this.server;
    }

    public A withServer(java.lang.String server) {
        this.server=server; return (A) this;
    }

    public java.lang.Boolean hasServer() {
        return this.server != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withServer instead.
     */
        public A withNewServer(java.lang.String arg0) {
        return (A)withServer(new String(arg0));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VaultIssuerFluentImpl that = (VaultIssuerFluentImpl) o;
        if (auth != null ? !auth.equals(that.auth) :that.auth != null) return false;
        if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
        if (namespace != null ? !namespace.equals(that.namespace) :that.namespace != null) return false;
        if (path != null ? !path.equals(that.path) :that.path != null) return false;
        if (server != null ? !server.equals(that.server) :that.server != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(auth,  caBundle,  namespace,  path,  server,  super.hashCode());
    }

    public class AuthNestedImpl<N> extends io.fabric8.certmanager.api.model.v1alpha3.VaultAuthFluentImpl<io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent.AuthNested<N>> implements io.fabric8.certmanager.api.model.v1alpha3.VaultIssuerFluent.AuthNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.certmanager.api.model.v1alpha3.VaultAuthBuilder builder;

            AuthNestedImpl(io.fabric8.certmanager.api.model.v1alpha3.VaultAuth item) {
                this.builder = new io.fabric8.certmanager.api.model.v1alpha3.VaultAuthBuilder(this, item);
                        
            }

            AuthNestedImpl() {
                this.builder = new io.fabric8.certmanager.api.model.v1alpha3.VaultAuthBuilder(this);
                        
            }

            public N and() {
                return (N) VaultIssuerFluentImpl.this.withAuth(builder.build());
            }

            public N endAuth() {
                return and();
            }
    }


}
